/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.opto.Block_List;
import sun.jvm.hotspot.opto.Phase;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class PhaseCFG
extends Phase {
    private static CIntField numBlocksField;
    private static AddressField blocksField;
    private static AddressField bbsField;
    private static AddressField brootField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("PhaseCFG");
        numBlocksField = new CIntField(type.getCIntegerField("_num_blocks"), 0L);
        blocksField = type.getAddressField("_blocks");
        bbsField = type.getAddressField("_bbs");
        brootField = type.getAddressField("_broot");
    }

    public PhaseCFG(Address addr) {
        super(addr);
    }

    public void dump(PrintStream out) {
        int addressSize = (int)VM.getVM().getAddressSize();
        int numBlocks = (int)numBlocksField.getValue(this.getAddress());
        Block_List blocks = new Block_List(this.getAddress().addOffsetTo(blocksField.getOffset()));
        boolean offset = false;
        for (int i = 0; i < numBlocks; ++i) {
            blocks.at(i).dump(out);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                PhaseCFG.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

