/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.util.ResourceBundle;
import javax.inject.Inject;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.osgi.service.log.LogService;

public class BundleTranslationProvider
extends TranslationService {
    @Inject
    ResourceBundleProvider provider;

    @Override
    public String translate(String key, String contributorURI) {
        if (this.provider == null) {
            return key;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundleForUri(contributorURI, ResourceBundleHelper.toLocale(this.locale), this.provider);
            return this.getResourceString(key, resourceBundle);
        }
        catch (Exception e) {
            LogService logService = ServicesActivator.getDefault().getLogService();
            if (logService != null) {
                logService.log(1, "Error retrieving the translation for key=" + key + " and contributorURI=" + contributorURI, (Throwable)e);
            }
            return key;
        }
    }
}

