/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ClassWriterImpl;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.TagletOutputImpl;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.builders.SerializedFormBuilder;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;

public class TagletWriterImpl
extends TagletWriter {
    private HtmlDocletWriter htmlWriter;

    public TagletWriterImpl(HtmlDocletWriter htmlWriter, boolean isFirstSentence) {
        this.htmlWriter = htmlWriter;
        this.isFirstSentence = isFirstSentence;
    }

    public TagletOutput getOutputInstance() {
        return new TagletOutputImpl("");
    }

    public TagletOutput getDocRootOutput() {
        if (this.htmlWriter.configuration.docrootparent.length() > 0) {
            return new TagletOutputImpl(this.htmlWriter.configuration.docrootparent);
        }
        return new TagletOutputImpl(this.htmlWriter.relativepathNoSlash);
    }

    public TagletOutput deprecatedTagOutput(Doc doc) {
        StringBuffer output = new StringBuffer();
        Tag[] deprs = doc.tags("deprecated");
        if (doc instanceof ClassDoc) {
            if (Util.isDeprecated((Doc)((ProgramElementDoc)doc))) {
                Tag[] commentTags;
                output.append("<span class=\"strong\">" + ConfigurationImpl.getInstance().getText("doclet.Deprecated") + "</span>&nbsp;");
                if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                    output.append(this.commentTagsToOutput(null, doc, deprs[0].inlineTags(), false).toString());
                }
            }
        } else {
            MemberDoc member = (MemberDoc)doc;
            if (Util.isDeprecated((Doc)((ProgramElementDoc)doc))) {
                output.append("<span class=\"strong\">" + ConfigurationImpl.getInstance().getText("doclet.Deprecated") + "</span>&nbsp;");
                if (deprs.length > 0) {
                    output.append("<i>");
                    output.append(this.commentTagsToOutput(null, doc, deprs[0].inlineTags(), false).toString());
                    output.append("</i>");
                }
            } else if (Util.isDeprecated((Doc)member.containingClass())) {
                output.append("<span class=\"strong\">" + ConfigurationImpl.getInstance().getText("doclet.Deprecated") + "</span>&nbsp;");
            }
        }
        return new TagletOutputImpl(output.toString());
    }

    public MessageRetriever getMsgRetriever() {
        return this.htmlWriter.configuration.message;
    }

    public TagletOutput getParamHeader(String header) {
        StringBuffer result = new StringBuffer();
        result.append("<dt>");
        result.append("<span class=\"strong\">" + header + "</span></dt>");
        return new TagletOutputImpl(result.toString());
    }

    public TagletOutput paramTagOutput(ParamTag paramTag, String paramName) {
        TagletOutputImpl result = new TagletOutputImpl("<dd><code>" + paramName + "</code>" + " - " + this.htmlWriter.commentTagsToString((Tag)paramTag, null, paramTag.inlineTags(), false) + "</dd>");
        return result;
    }

    public TagletOutput returnTagOutput(Tag returnTag) {
        TagletOutputImpl result = new TagletOutputImpl(DocletConstants.NL + "<dt>" + "<span class=\"strong\">" + this.htmlWriter.configuration.getText("doclet.Returns") + "</span>" + "</dt>" + "<dd>" + this.htmlWriter.commentTagsToString(returnTag, null, returnTag.inlineTags(), false) + "</dd>");
        return result;
    }

    public TagletOutput seeTagOutput(Doc holder, SeeTag[] seeTags) {
        String result = "";
        if (seeTags.length > 0) {
            result = this.addSeeHeader(result);
            for (int i = 0; i < seeTags.length; ++i) {
                if (i > 0) {
                    result = result + ", " + DocletConstants.NL;
                }
                result = result + this.htmlWriter.seeTagToString(seeTags[i]);
            }
        }
        if (holder.isField() && ((FieldDoc)holder).constantValue() != null && this.htmlWriter instanceof ClassWriterImpl) {
            result = this.addSeeHeader(result);
            result = result + this.htmlWriter.getHyperLinkString(this.htmlWriter.relativePath + "constant-values.html" + "#" + ((ClassWriterImpl)this.htmlWriter).getClassDoc().qualifiedName() + "." + ((FieldDoc)holder).name(), this.htmlWriter.configuration.getText("doclet.Constants_Summary"));
        }
        if (holder.isClass() && ((ClassDoc)holder).isSerializable() && SerializedFormBuilder.serialInclude(holder) && SerializedFormBuilder.serialInclude((Doc)((ClassDoc)holder).containingPackage())) {
            result = this.addSeeHeader(result);
            result = result + this.htmlWriter.getHyperLinkString(this.htmlWriter.relativePath + "serialized-form.html", ((ClassDoc)holder).qualifiedName(), this.htmlWriter.configuration.getText("doclet.Serialized_Form"), false);
        }
        return result.equals("") ? null : new TagletOutputImpl(result + "</dd>");
    }

    private String addSeeHeader(String result) {
        if (result != null && result.length() > 0) {
            return result + ", " + DocletConstants.NL;
        }
        return "<dt><span class=\"strong\">" + this.htmlWriter.configuration().getText("doclet.See_Also") + "</span></dt><dd>";
    }

    public TagletOutput simpleTagOutput(Tag[] simpleTags, String header) {
        String result = "<dt><span class=\"strong\">" + header + "</span></dt>" + DocletConstants.NL + "  <dd>";
        for (int i = 0; i < simpleTags.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + this.htmlWriter.commentTagsToString(simpleTags[i], null, simpleTags[i].inlineTags(), false);
        }
        result = result + "</dd>" + DocletConstants.NL;
        return new TagletOutputImpl(result);
    }

    public TagletOutput simpleTagOutput(Tag simpleTag, String header) {
        return new TagletOutputImpl("<dt><span class=\"strong\">" + header + "</span></dt>" + "  <dd>" + this.htmlWriter.commentTagsToString(simpleTag, null, simpleTag.inlineTags(), false) + "</dd>" + DocletConstants.NL);
    }

    public TagletOutput getThrowsHeader() {
        return new TagletOutputImpl(DocletConstants.NL + "<dt>" + "<span class=\"strong\">" + this.htmlWriter.configuration().getText("doclet.Throws") + "</span></dt>");
    }

    public TagletOutput throwsTagOutput(ThrowsTag throwsTag) {
        String result = DocletConstants.NL + "<dd>";
        result = result + (throwsTag.exceptionType() == null ? this.htmlWriter.codeText(throwsTag.exceptionName()) : this.htmlWriter.codeText(this.htmlWriter.getLink(new LinkInfoImpl(3, throwsTag.exceptionType()))));
        TagletOutputImpl text = new TagletOutputImpl(this.htmlWriter.commentTagsToString((Tag)throwsTag, null, throwsTag.inlineTags(), false));
        if (text != null && ((Object)text).toString().length() > 0) {
            result = result + " - " + text;
        }
        result = result + "</dd>";
        return new TagletOutputImpl(result);
    }

    public TagletOutput throwsTagOutput(Type throwsType) {
        return new TagletOutputImpl(DocletConstants.NL + "<dd>" + this.htmlWriter.codeText(this.htmlWriter.getLink(new LinkInfoImpl(3, throwsType))) + "</dd>");
    }

    public TagletOutput valueTagOutput(FieldDoc field, String constantVal, boolean includeLink) {
        return new TagletOutputImpl(includeLink ? this.htmlWriter.getDocLink(11, (MemberDoc)field, constantVal, false) : constantVal);
    }

    public TagletOutput commentTagsToOutput(Tag holderTag, Tag[] tags) {
        return this.commentTagsToOutput(holderTag, null, tags, false);
    }

    public TagletOutput commentTagsToOutput(Doc holderDoc, Tag[] tags) {
        return this.commentTagsToOutput(null, holderDoc, tags, false);
    }

    public TagletOutput commentTagsToOutput(Tag holderTag, Doc holderDoc, Tag[] tags, boolean isFirstSentence) {
        return new TagletOutputImpl(this.htmlWriter.commentTagsToString(holderTag, holderDoc, tags, isFirstSentence));
    }

    public Configuration configuration() {
        return this.htmlWriter.configuration();
    }

    public TagletOutput getTagletOutputInstance() {
        return new TagletOutputImpl("");
    }
}

