/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.OptionHelper;

public class OpenTypeConvertibleValue<T extends Comparable<T>>
implements IConvertibleValue<T> {
    private final IOptionConstraint<T> constraint;
    private final T value;

    public static <T extends Comparable<T>> IConvertibleValue<T> createWithCast(IOptionConstraint<T> constraint, Object value) {
        return new OpenTypeConvertibleValue<Comparable>(constraint, (Comparable)constraint.getType().cast(value));
    }

    public OpenTypeConvertibleValue(IOptionConstraint<T> constraint, T value) {
        this.constraint = constraint;
        this.value = value;
    }

    @Override
    public IOptionConstraint<T> getConstraint() {
        return this.constraint;
    }

    @Override
    public T toServerOpenType() {
        return this.value;
    }

    @Override
    public String toConfigString() {
        return OptionHelper.toConfigString(this.constraint, this.value);
    }

    @Override
    public IConvertibleValue<T> toCanonical() {
        return this;
    }

    public boolean equals(Object other) {
        return other instanceof IConvertibleValue && this.value.equals(((IConvertibleValue)other).toServerOpenType());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

