/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import com.jrockit.mc.rjmx.subscription.internal.DefaultUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.OneShotUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.SimpleUpdatePolicy;

public final class UpdatePolicyToolkit {
    private UpdatePolicyToolkit() throws InstantiationException {
        throw new InstantiationException("Should not be instantiated!");
    }

    public static int getDefaultUpdateInterval() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getInt("com.jrockit.console.preferences.updateinterval", 1000);
    }

    public static int getUpdateInterval(IConnectionHandle handle, MRI mri) {
        Integer time;
        IMRIMetaDataService metaDataService = UpdatePolicyToolkit.getMetaDataService(handle);
        if (metaDataService != null && (time = (Integer)metaDataService.getMetaData(mri, "UpdateTime")) != null) {
            return time;
        }
        return -1;
    }

    public static int getUpdateTime(IConnectionHandle handle, MRI attributeDescriptor) {
        int time = UpdatePolicyToolkit.getUpdateInterval(handle, attributeDescriptor);
        if (time > -1) {
            return time;
        }
        return UpdatePolicyToolkit.getDefaultUpdateInterval();
    }

    public static void setUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor, IUpdatePolicy policy) {
        IMRIMetaDataService metaDataService = UpdatePolicyToolkit.getMetaDataService(handle);
        if (metaDataService == null) {
            return;
        }
        if (policy instanceof OneShotUpdatePolicy) {
            metaDataService.setMetaData(attributeDescriptor, "UpdateTime", 0);
        } else if (policy instanceof SimpleUpdatePolicy) {
            SimpleUpdatePolicy s = (SimpleUpdatePolicy)policy;
            metaDataService.setMetaData(attributeDescriptor, "UpdateTime", s.getIntervalTime());
        } else if (policy instanceof DefaultUpdatePolicy) {
            metaDataService.setMetaData(attributeDescriptor, "UpdateTime", -1);
        } else {
            throw new UnsupportedOperationException(policy.getClass() + "is not supported!");
        }
        UpdatePolicyToolkit.updateExistingSubscription(handle, attributeDescriptor);
    }

    private static void updateExistingSubscription(IConnectionHandle handle, MRI attributeDescriptor) {
        ISubscriptionService service = handle.getServiceOrNull(ISubscriptionService.class);
        if (service == null) {
            return;
        }
        IMRISubscription attributeSubscription = service.getMRISubscription(attributeDescriptor);
        if (attributeSubscription != null) {
            attributeSubscription.setUpdatePolicy(UpdatePolicyToolkit.getUpdatePolicy(handle, attributeDescriptor));
        }
    }

    public static IUpdatePolicy getUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor) {
        return UpdatePolicyToolkit.getUpdatePolicy(UpdatePolicyToolkit.getUpdateInterval(handle, attributeDescriptor));
    }

    public static IUpdatePolicy getUpdatePolicy(int updateInterval) {
        if (updateInterval <= -1) {
            return PolicyFactory.createDefaultUpdatePolicy();
        }
        if (updateInterval == 0) {
            return PolicyFactory.createOneShotPolicy();
        }
        return PolicyFactory.createSimpleUpdatePolicy(updateInterval);
    }

    private static IMRIMetaDataService getMetaDataService(IConnectionHandle handle) {
        return handle.getServiceOrNull(IMRIMetaDataService.class);
    }
}

