/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view;

import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.actions.DesignModeAction;
import com.jrockit.mc.components.ui.design.view.layout.LayoutPage;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public final class DesignView
extends PageBookView
implements IPageChangedListener {
    private TabPage m_tabPage;
    private DesignEditor m_lastEditor;
    private DesignModeAction m_action;

    public void init(IViewSite site) throws PartInitException {
        this.m_action = new DesignModeAction(this);
        site.getActionBars().getToolBarManager().add((IAction)this.m_action);
        super.init(site);
    }

    public void partActivated(IWorkbenchPart part) {
        IWorkbenchPage activePage;
        IEditorPart activeEditor;
        if (part instanceof DesignEditor) {
            if (this.m_lastEditor != null) {
                this.m_lastEditor.removePageChangedListener(this);
            }
            this.m_lastEditor = (DesignEditor)part;
            this.m_lastEditor.addPageChangedListener(this);
        }
        IEditorPart iEditorPart = activeEditor = (activePage = this.getSite().getWorkbenchWindow().getActivePage()) == null ? null : activePage.getActiveEditor();
        if (activeEditor instanceof MultiPageEditorPart) {
            this.updateViewForTab(DesignView.designTabOrNull(((MultiPageEditorPart)activeEditor).getSelectedPage()));
        } else {
            this.updateViewForTab(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.m_lastEditor != null) {
            this.m_lastEditor.removePageChangedListener(this);
            this.m_lastEditor = null;
        }
        super.partDeactivated(part);
    }

    protected IPage createDefaultPage(PageBook book) {
        this.m_tabPage = new TabPage();
        this.initPage((IPageBookViewPage)this.m_tabPage);
        this.m_tabPage.createControl((Composite)book);
        return this.m_tabPage;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof DesignEditor) {
            LayoutPage p = new LayoutPage();
            this.initPage((IPageBookViewPage)p);
            p.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)p);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (part instanceof DesignEditor) {
            pageRecord.page.dispose();
            pageRecord.dispose();
            if (this.m_tabPage != null) {
                this.m_tabPage.refresh();
            }
        }
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part = this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.isImportant((IWorkbenchPart)part)) {
            return part;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part == null || part instanceof DesignEditor;
    }

    public void pageChanged(PageChangedEvent event) {
        this.updateViewForTab(DesignView.designTabOrNull(event.getSelectedPage()));
    }

    private void updateViewForTab(DesignerTab tab) {
        PageBookView.PageRec rec;
        this.showPageForTab(tab);
        this.m_action.setTab(tab);
        if (tab != null && (rec = this.getPageRec((IWorkbenchPart)tab.getEditor())) != null && rec.page instanceof LayoutPage) {
            ((LayoutPage)rec.page).setTab(tab);
            ((LayoutPage)rec.page).update();
        }
    }

    public void showPageForTab(DesignerTab tab) {
        if (tab != null && tab.isInDesignMode()) {
            super.partActivated((IWorkbenchPart)tab.getEditor());
        } else {
            super.partActivated(null);
            if (this.m_tabPage != null) {
                this.m_tabPage.refresh();
            }
        }
    }

    private static DesignerTab designTabOrNull(Object tab) {
        return (DesignerTab)((Object)(tab instanceof DesignerTab ? tab : null));
    }
}

