/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.StringInput;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

abstract class NumberInput<T extends Number>
extends StringInput {
    private T m_minimum;
    private T m_maximum;

    public NumberInput(String property, String name, T min, T max) {
        super(property, name);
        this.m_minimum = min;
        this.m_maximum = max;
    }

    public final void setMinimum(T minimum) {
        this.m_minimum = minimum;
    }

    public final void setMaximum(T maximum) {
        this.m_maximum = maximum;
    }

    protected abstract Comparable<T> createObjectFromString(String var1);

    @Override
    protected final void hookTextListener(final Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NumberInput.this.isEnabled()) {
                    NumberInput.this.setPropertyValue(text.getText());
                    NumberInput.this.markStale();
                }
            }
        });
    }

    @Override
    public IStatus getStatus() {
        Comparable<T> object = this.createObjectFromString(this.getPropertyValue());
        if (object != null) {
            if (object.compareTo(this.m_maximum) > 0) {
                return new Status(4, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALUE_TOO_LARGE_TEXT, this.getName(), this.m_maximum));
            }
            if (object.compareTo(this.m_minimum) < 0) {
                return new Status(4, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALUE_TOO_SMALL_TEXT, this.getName(), this.m_minimum));
            }
            return new Status(1, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_VALID_INPUT_TEXT, this.getName()));
        }
        return new Status(4, "com.jrockit.mc.components.ui", MessageFormat.format(Messages.NUMBER_INPUT_NOT_A_VALID_INPUT_TEXT, this.getName()));
    }
}

