/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.common.IMemberAccessor;
import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.IPrefix;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.core.MCConstants;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.services.IAttributeChild;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.services.IUpdateInterval;
import com.jrockit.mc.rjmx.subscription.IAttributeTransformationService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRITransformationFactory;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import com.jrockit.mc.rjmx.ui.attributes.AsyncService;
import com.jrockit.mc.rjmx.ui.attributes.AttributeTreeBuilder;
import com.jrockit.mc.rjmx.ui.attributes.ChangeValueAction;
import com.jrockit.mc.rjmx.ui.attributes.EditDisplayNameAction;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.rjmx.ui.attributes.SetUnitMenuManager;
import com.jrockit.mc.rjmx.ui.attributes.UpdateIntervalManager;
import com.jrockit.mc.rjmx.ui.attributes.ValueColumnLabelProvider;
import com.jrockit.mc.rjmx.ui.attributes.VisualizeAction;
import com.jrockit.mc.rjmx.ui.celleditors.AttributeEditingSupport;
import com.jrockit.mc.rjmx.ui.celleditors.UnitCellEditor;
import com.jrockit.mc.rjmx.ui.celleditors.UpdateIntervalEditingSupport;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.OptimisticComparator;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.ui.column.TypedLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.InsertArrayElementMenuAction;
import com.jrockit.mc.rjmx.ui.internal.RemoveArrayElementMenuAction;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.ui.handlers.CommandAction;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.misc.SWTColorToolkit;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.management.Descriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class MRIAttributeInspector {
    private static final int MAX_DESCRIPTORS = 8;
    private static final int TOOLTIP_MAX_LENGTH = 100;
    private static final String NOT_AVAILABLE = String.valueOf('[') + MCConstants.NOT_AVAILABLE + ']';
    public static final String MBEANBROWSER_ATTRIBUTESTAB_ATTRIBUTESTREE_NAME = "mbeanbrowser.AttributesTab.AttributesTree";
    private final Observer metaDataObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            MRIAttributeInspector.this.tree.getViewer().getTree().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MRIAttributeInspector.this.tree.isDisposed()) {
                        MRIAttributeInspector.this.tree.getViewer().refresh(true);
                    }
                }
            });
        }
    };
    private final IAction refreshAction = new CommandAction("org.eclipse.ui.file.refresh"){

        public void run() {
            MRIAttributeInspector.this.asyncRefresh(true, MRIAttributeInspector.this.elements);
        }
    };
    private final IConnectionHandle connection;
    private final AsyncService asyncService = new AsyncService();
    private final SectionPartManager sectionPartManager;
    private final TreeColumnComposite tree;
    private final MRIAttributeEditingSupport valueEditingSupport;
    private Collection<?> elements = Collections.emptyList();

    public MRIAttributeInspector(SectionPartManager sectionPartManager, Composite parent, IDialogSettings settings, IConnectionHandle connectionHandle, boolean useOnlyDisplayName) {
        this.sectionPartManager = sectionPartManager;
        this.connection = connectionHandle;
        this.tree = AttributeTreeBuilder.build(parent, settings);
        this.tree.getViewer().getTree().setData("name", (Object)MBEANBROWSER_ATTRIBUTESTAB_ATTRIBUTESTREE_NAME);
        this.valueEditingSupport = new MRIAttributeEditingSupport((ColumnViewer)this.tree.getViewer());
        Column nameColumn = new Column(Messages.AttributeInspector_NAME_COLUMN_HEADER, "name", new NameLabelProvider(useOnlyDisplayName), new OptimisticComparator());
        Column valueColumn = new Column(Messages.AttributeInspector_VALUE_COLUMN_HEADER, null, "value", 0, new ValueLabelProvider(), new ValueAccessor(), this.valueEditingSupport, new ValueComparator());
        Column typeColumn = new Column(Messages.AttributeInspector_TYPE_COLUMN_HEADER, "type", new TypeLabelProvider());
        this.tree.addColumns(nameColumn, valueColumn, typeColumn);
        if (!useOnlyDisplayName) {
            this.tree.addColumns(new Column(Messages.MRIAttributeInspector_DISPLAY_NAME_COLUMN_HEADER, "displayName", new DisplayNameLabelProvider()));
        }
        Column updateColumn = new Column(Messages.MRIAttributeInspector_UPDATE_INTERVAL_COLUMN_HEADER, null, "update", 0, new UpdateIntervalLabelProvider(), new UpdateIntervalAccessor(), new UpdateIntervalEditingSupportWithRefresh((ColumnViewer)this.tree.getViewer()));
        Column descriptionColumn = new Column(Messages.MRIAttributeInspector_DESCRIPTION_COLUMN_HEADER, "description", new DescriptionLabelProvider());
        this.tree.addColumns(updateColumn, descriptionColumn);
        this.tree.getMenuManager().add((IAction)new ChangeValueAction(this.tree, valueColumn));
        this.tree.getMenuManager().add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution(this.tree, valueColumn, false));
        this.tree.getMenuManager().add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution(this.tree, valueColumn, true));
        this.tree.getMenuManager().add((IContributionItem)RemoveArrayElementMenuAction.createRemoveArrayElementMenuActionContribution(this.tree, valueColumn));
        this.tree.getMenuManager().add((IContributionItem)new Separator());
        this.tree.getMenuManager().add(this.refreshAction);
        if (sectionPartManager != null) {
            this.tree.getMenuManager().add((IContributionItem)new Separator());
            this.addVisualizeContextMenuActions(this.tree.getMenuManager());
            this.tree.getMenuManager().add((IContributionItem)new Separator());
        }
        this.tree.getMenuManager().add((IContributionItem)new UpdateIntervalManager(this.tree.getViewer()).getUpdateIntervalMenu());
        this.tree.getMenuManager().add((IContributionItem)new SetUnitMenuManager((ISelectionProvider)this.tree.getViewer(), this.connection, this.tree.getMenuManager()));
        final IMRIMetaDataService mds = (IMRIMetaDataService)this.connection.getServiceOrDummy(IMRIMetaDataService.class);
        this.tree.getMenuManager().add((IAction)new EditDisplayNameAction(mds, (ISelectionProvider)this.tree.getViewer()));
        mds.addObserver(this.metaDataObserver);
        this.tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                mds.deleteObserver(MRIAttributeInspector.this.metaDataObserver);
            }
        });
        InFocusHandlerActivator.install((Control)this.tree.getViewer().getControl(), (IAction)this.refreshAction);
        this.setupDoubleClickListener();
    }

    public void setInput(Collection<?> elements) {
        this.elements = elements;
        this.tree.getViewer().setInput((Object)elements.toArray());
        this.asyncRefresh(true, elements);
    }

    public TreeColumnComposite getControl() {
        return this.tree;
    }

    private void setupDoubleClickListener() {
        this.tree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object elementNode = selection.getFirstElement();
                MRIAttributeInspector.this.tree.getViewer().setExpandedState(elementNode, !MRIAttributeInspector.this.tree.getViewer().getExpandedState(elementNode));
            }
        });
    }

    private void addVisualizeContextMenuActions(MenuManager menuManager) {
        menuManager.add((IAction)new VisualizeAction(Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TEXT, this.sectionPartManager, this.connection, (ISelectionProvider)this.tree.getViewer()));
        IAttributeTransformationService transformationService = (IAttributeTransformationService)this.connection.getServiceOrNull(IAttributeTransformationService.class);
        if (transformationService != null) {
            MenuManager transformationMenu = menuManager;
            int count = this.countFactories(transformationService);
            if (count > 1) {
                transformationMenu = new MenuManager(Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TRANSFORM_TEXT);
                menuManager.add((IContributionItem)transformationMenu);
            }
            for (IMRITransformationFactory transformationFactory : transformationService.getFactories()) {
                transformationMenu.add((IAction)new VisualizeAction(transformationFactory.getVisualizationLabel(), this.sectionPartManager, this.connection, (ISelectionProvider)this.tree.getViewer(), transformationFactory));
            }
        }
    }

    private int countFactories(IAttributeTransformationService transformationService) {
        int count = 0;
        Iterator iter = transformationService.getFactories().iterator();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    private String getDisplayNameText(ReadOnlyMRIAttribute attribute) {
        return MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.connection, (MRI)attribute.getMRI());
    }

    private String getDescriptionText(ReadOnlyMRIAttribute attribute) {
        return MRIMetaDataToolkit.getDescription((IConnectionHandle)this.connection, (MRI)attribute.getMRI());
    }

    private static String getTypeText(ReadOnlyMRIAttribute attribute) {
        if (attribute.getInfo().getType() == null) {
            return NOT_AVAILABLE;
        }
        IUnit<?> unit = attribute.getUnit();
        return unit == null ? TypeHandling.simplifyType((String)attribute.getInfo().getType()) : unit.getContentType().getName();
    }

    private static IUnit<?> getUnit(Object attribute) {
        if (attribute instanceof ReadOnlyMRIAttribute) {
            return ((ReadOnlyMRIAttribute)((Object)attribute)).getUnit();
        }
        if (attribute instanceof IAttributeChild) {
            return null;
        }
        return null;
    }

    private void asyncRefresh(final boolean fullRefresh, final Collection<?> elements) {
        this.asyncService.submit(new Runnable(){

            @Override
            public void run() {
                HashMap<MRI, ReadOnlyMRIAttribute> attributeMap = new HashMap<MRI, ReadOnlyMRIAttribute>();
                for (Object element : elements) {
                    ReadOnlyMRIAttribute mriAttribute;
                    if (!(element instanceof ReadOnlyMRIAttribute) || (mriAttribute = (ReadOnlyMRIAttribute)((Object)element)).getMRI().getType() != MRI.Type.ATTRIBUTE) continue;
                    attributeMap.put(mriAttribute.getMRI(), mriAttribute);
                }
                ReadOnlyMRIAttribute.refresh(MRIAttributeInspector.this.connection, attributeMap);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (!MRIAttributeInspector.this.tree.getViewer().getTree().isDisposed()) {
                    if (fullRefresh) {
                        MRIAttributeInspector.this.tree.getViewer().refresh();
                    } else {
                        MRIAttributeInspector.this.tree.getViewer().update(elements.toArray(), null);
                    }
                }
            }
        });
    }

    private static String valueOrNotAvailable(Object value) {
        if (value == null) {
            return NOT_AVAILABLE;
        }
        return String.valueOf(value);
    }

    private class DescriptionLabelProvider
    extends TypedLabelProvider<ReadOnlyMRIAttribute> {
        public DescriptionLabelProvider() {
            super(ReadOnlyMRIAttribute.class);
        }

        @Override
        protected String getTextTyped(ReadOnlyMRIAttribute element) {
            return MRIAttributeInspector.this.getDescriptionText(element);
        }

        @Override
        protected String getDefaultText(Object element) {
            if (element instanceof ErroneousAttribute) {
                return String.valueOf(((ErroneousAttribute)element).getDescriptionText());
            }
            return super.getDefaultText(element);
        }
    }

    private class DisplayNameLabelProvider
    extends TypedLabelProvider<IReadOnlyAttribute> {
        public DisplayNameLabelProvider() {
            super(IReadOnlyAttribute.class);
        }

        @Override
        protected String getTextTyped(IReadOnlyAttribute element) {
            return element instanceof ReadOnlyMRIAttribute ? MRIAttributeInspector.this.getDisplayNameText((ReadOnlyMRIAttribute)element) : element.getInfo().getName();
        }
    }

    public static class ErroneousAttribute {
        private final String errorDescription;
        private final String name;
        private final String type;
        private final String description;

        public ErroneousAttribute(String name, String type, String description) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.errorDescription = name == null ? Messages.MRIAttributeInspector_ATTRIBUTE_NAME_MISSING : (type == null ? Messages.MRIAttributeInspector_ATTRIBUTE_TYPE_MISSING : null);
        }

        public String toString() {
            return this.errorDescription;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescriptionText() {
            return this.description != null ? this.description : "";
        }
    }

    private static class MRIAttributeEditingSupport
    extends AttributeEditingSupport<IAttribute> {
        private final UnitCellEditor unitCellEditor;

        public MRIAttributeEditingSupport(ColumnViewer viewer) {
            super(viewer, IAttribute.class);
            this.unitCellEditor = new UnitCellEditor((Composite)viewer.getControl());
        }

        @Override
        protected CellEditor getCellEditorTyped(IAttribute element) {
            IUnit unit = MRIAttributeInspector.getUnit(element);
            String type = element.getInfo().getType();
            if (unit != null && UnitCellEditor.canEdit(type)) {
                this.unitCellEditor.setUnit(unit, type);
                return this.unitCellEditor;
            }
            return super.getCellEditorTyped(element);
        }

        @Override
        protected boolean canEditTyped(IAttribute element) {
            return element.getValue() != MRIValue.UNAVAILABLE_VALUE && (MRIAttributeInspector.getUnit(element) != null && UnitCellEditor.canEdit(element.getInfo().getType()) || super.canEditTyped(element));
        }

        @Override
        protected void setValueTyped(IAttribute element, Object value) {
            super.setValueTyped(element, value);
            this.getViewer().refresh();
        }
    }

    private class NameLabelProvider
    extends TypedLabelProvider<ReadOnlyMRIAttribute> {
        private static final String COLON_SPACE = ": ";
        private static final String COLON_NL = ":\n";
        private static final String COLON_NL_SPACE = ":\n ";
        private static final String NL_SPACE = "\n ";
        private static final String NL = "\n";
        private static final String ELLIPSIS_STRING = "...";
        private final boolean useOnlyDisplayName;

        public NameLabelProvider(boolean useOnlyDisplayName) {
            super(ReadOnlyMRIAttribute.class);
            this.useOnlyDisplayName = useOnlyDisplayName;
        }

        @Override
        protected String getDefaultText(Object element) {
            if (element instanceof ReadOnlyMRIAttribute && this.useOnlyDisplayName) {
                return MRIAttributeInspector.this.getDisplayNameText((ReadOnlyMRIAttribute)((Object)element));
            }
            if (element instanceof IReadOnlyAttribute) {
                return ((IReadOnlyAttribute)element).getInfo().getName();
            }
            if (element instanceof ErroneousAttribute) {
                return MRIAttributeInspector.valueOrNotAvailable(((ErroneousAttribute)element).getName());
            }
            return element == null ? "" : element.toString();
        }

        @Override
        public org.eclipse.swt.graphics.Color getForeground(Object element) {
            if (element instanceof ErroneousAttribute) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }

        @Override
        public Font getFont(Object element) {
            if (element instanceof ErroneousAttribute) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            if (element instanceof IAttribute) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            return JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        }

        @Override
        protected Image getImageTyped(ReadOnlyMRIAttribute element) {
            IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)MRIAttributeInspector.this.connection, (MRI)element.getMRI());
            if (metaData == null) {
                return null;
            }
            Color color = MRIMetaDataToolkit.getColor((IMRIMetaDataProvider)metaData);
            return color == null ? null : SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)color));
        }

        @Override
        protected Image getToolTipImageTyped(ReadOnlyMRIAttribute element) {
            return this.getImageTyped(element);
        }

        @Override
        protected org.eclipse.swt.graphics.Color getBackgroundTyped(ReadOnlyMRIAttribute element) {
            Descriptor desc;
            IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)MRIAttributeInspector.this.connection, (MRI)element.getMRI());
            Descriptor descriptor = desc = metaData == null ? null : MRIMetaDataToolkit.getDescriptor((IMRIMetaDataProvider)metaData);
            if (desc != null && "true".equals(desc.getFieldValue("synthetic"))) {
                return Display.getDefault().getSystemColor(22);
            }
            return null;
        }

        @Override
        protected String getToolTipTextTyped(ReadOnlyMRIAttribute element) {
            Descriptor desc;
            StringBuilder sb = new StringBuilder();
            if (element.getRefreshProblem() != null) {
                sb.append(Messages.MRIAttributeInspector_ERROR_GETTING_VALUE).append(COLON_NL).append(element.getRefreshProblem()).append(NL).append(NL);
            } else if (element.getInfo().getType() == null) {
                sb.append(Messages.MRIAttributeInspector_ERROR_IN_ATTRIBUTE).append(COLON_NL).append(Messages.MRIAttributeInspector_ATTRIBUTE_TYPE_MISSING).append(NL).append(NL);
            }
            sb.append(Messages.AttributeInspector_NAME_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(this.getText((Object)element))).append(NL);
            sb.append(Messages.MRIAttributeInspector_DISPLAY_NAME_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(MRIAttributeInspector.this.getDisplayNameText(element))).append(NL);
            sb.append(Messages.MRIAttributeInspector_DESCRIPTION_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(MRIAttributeInspector.this.getDescriptionText(element))).append(NL);
            sb.append(Messages.AttributeInspector_VALUE_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(TypeHandling.getValueString((Object)element.getValue()))).append(NL);
            sb.append(Messages.AttributeInspector_TYPE_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(TypeHandling.simplifyType((String)element.getInfo().getType()))).append(NL);
            IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)MRIAttributeInspector.this.connection, (MRI)element.getMRI());
            Descriptor descriptor = desc = metaData == null ? null : MRIMetaDataToolkit.getDescriptor((IMRIMetaDataProvider)metaData);
            if (desc != null && desc.getFields() != null && desc.getFields().length > 0) {
                sb.append(Messages.MRIAttributeInspector_DESCRIPTOR).append(COLON_NL_SPACE);
                String[] fields = desc.getFields();
                int i = 0;
                while (i < Math.min(fields.length, 8)) {
                    sb.append(this.shorten(fields[i])).append(NL_SPACE);
                    ++i;
                }
            }
            return sb.toString().trim();
        }

        @Override
        public String getToolTipText(Object element) {
            if (element instanceof ErroneousAttribute) {
                ErroneousAttribute attr = (ErroneousAttribute)element;
                StringBuilder sb = new StringBuilder();
                sb.append(Messages.MRIAttributeInspector_ERROR_IN_ATTRIBUTE).append(COLON_NL).append(attr.getErrorDescription()).append(NL).append(NL);
                sb.append(Messages.AttributeInspector_NAME_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(String.valueOf(attr.getName()))).append(NL);
                sb.append(Messages.MRIAttributeInspector_DESCRIPTION_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(String.valueOf(attr.getDescriptionText()))).append(NL);
                sb.append(Messages.AttributeInspector_TYPE_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(String.valueOf(attr.getType()))).append(NL);
                return sb.toString().trim();
            }
            return super.getToolTipText(element);
        }

        private String shorten(String s) {
            if (s.length() > 100) {
                return s.subSequence(0, 100 - ELLIPSIS_STRING.length()) + ELLIPSIS_STRING;
            }
            return s;
        }
    }

    private static class TypeLabelProvider
    extends TypedLabelProvider<IReadOnlyAttribute> {
        public TypeLabelProvider() {
            super(IReadOnlyAttribute.class);
        }

        @Override
        protected String getTextTyped(IReadOnlyAttribute attribute) {
            if (attribute instanceof ReadOnlyMRIAttribute) {
                return MRIAttributeInspector.getTypeText((ReadOnlyMRIAttribute)attribute);
            }
            return TypeHandling.simplifyType((String)attribute.getInfo().getType());
        }

        @Override
        protected String getDefaultText(Object element) {
            if (element instanceof ErroneousAttribute) {
                return MRIAttributeInspector.valueOrNotAvailable(((ErroneousAttribute)element).getType());
            }
            return super.getDefaultText(element);
        }

        @Override
        public org.eclipse.swt.graphics.Color getForeground(Object element) {
            if (this.typeIsNull(element)) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }

        @Override
        public Font getFont(Object element) {
            if (this.typeIsNull(element)) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            return super.getFont(element);
        }

        @Override
        public String getToolTipText(Object element) {
            if (this.typeIsNull(element)) {
                return Messages.MRIAttributeInspector_ATTRIBUTE_TYPE_MISSING;
            }
            return super.getToolTipText(element);
        }

        private boolean typeIsNull(Object element) {
            if (element instanceof ErroneousAttribute && ((ErroneousAttribute)element).getType() == null) {
                return true;
            }
            return element instanceof IReadOnlyAttribute && ((IReadOnlyAttribute)element).getInfo().getType() == null;
        }
    }

    private static class UpdateIntervalAccessor
    implements IMemberAccessor<Object, Object> {
        private UpdateIntervalAccessor() {
        }

        public Object getMember(Object o) {
            if (o instanceof IUpdateInterval) {
                return ((IUpdateInterval)o).getUpdateInterval();
            }
            return null;
        }
    }

    private static class UpdateIntervalEditingSupportWithRefresh
    extends UpdateIntervalEditingSupport {
        public UpdateIntervalEditingSupportWithRefresh(ColumnViewer viewer) {
            super(viewer);
        }

        @Override
        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            this.getViewer().refresh(element);
        }
    }

    private static class UpdateIntervalLabelProvider
    extends TypedLabelProvider<IUpdateInterval> {
        private static final LinearUnit MILLISECONDS = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.MILLI);

        public UpdateIntervalLabelProvider() {
            super(IUpdateInterval.class);
        }

        @Override
        protected String getTextTyped(IUpdateInterval paramater) {
            int val = paramater.getUpdateInterval();
            switch (val) {
                case -1: {
                    return Messages.MRIAttributeInspector_UPDATE_INTERVAL_DEFAULT;
                }
                case 0: {
                    return Messages.MRIAttributeInspector_UPDATE_INTERVAL_ONCE;
                }
            }
            return MILLISECONDS.quantity((long)val).displayUsing("auto");
        }
    }

    private static class ValueAccessor
    implements IMemberAccessor<Object, Object> {
        private ValueAccessor() {
        }

        public Object getMember(Object o) {
            if (o instanceof IReadOnlyAttribute) {
                return ValueAccessor.getValue((IReadOnlyAttribute)o);
            }
            return null;
        }

        private static Object getValue(IReadOnlyAttribute a) {
            Object val = a.getValue();
            if (a instanceof ReadOnlyMRIAttribute) {
                IUnit<?> unit = ((ReadOnlyMRIAttribute)a).getUnit();
                if (val instanceof Number && unit != null) {
                    return unit.quantity((Number)val);
                }
            }
            return val;
        }
    }

    private static class ValueComparator
    implements Comparator<Object> {
        private ValueComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Number n1 = this.getNumber(o1);
            Number n2 = this.getNumber(o2);
            if (n1 != null) {
                if (n2 != null) {
                    IUnit unit1 = MRIAttributeInspector.getUnit(o1);
                    IUnit unit2 = MRIAttributeInspector.getUnit(o2);
                    if (unit1 != null) {
                        if (unit2 != null) {
                            if (unit1.getContentType().equals(unit2.getContentType())) {
                                return unit1.quantity(n1).compareTo((Object)unit2.quantity(n2));
                            }
                            return unit1.getContentType().getIdentifier().compareTo(unit2.getContentType().getIdentifier());
                        }
                        return -1;
                    }
                    return unit2 != null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue());
                }
                return -1;
            }
            return n2 != null ? 1 : 0;
        }

        private Number getNumber(Object o) {
            Object v;
            if (o instanceof IReadOnlyAttribute && (v = ((IReadOnlyAttribute)o).getValue()) instanceof Number) {
                return (Number)v;
            }
            return null;
        }
    }

    private class ValueLabelProvider
    extends ValueColumnLabelProvider {
        private ValueLabelProvider() {
        }

        @Override
        protected org.eclipse.swt.graphics.Color getForegroundTyped(IReadOnlyAttribute attribute) {
            if (attribute.getValue() == MRIValue.UNAVAILABLE_VALUE) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return super.getForegroundTyped(attribute);
        }

        @Override
        protected org.eclipse.swt.graphics.Color getBackgroundTyped(IReadOnlyAttribute element) {
            return MRIAttributeInspector.this.valueEditingSupport.canEdit(element) ? Display.getDefault().getSystemColor(29) : null;
        }

        @Override
        protected boolean isValid(IReadOnlyAttribute attribute) {
            return super.isValid(attribute) && attribute.getValue() != MRIValue.UNAVAILABLE_VALUE;
        }

        @Override
        protected String getToolTipTextTyped(IReadOnlyAttribute attribute) {
            if (attribute instanceof ReadOnlyMRIAttribute && ((ReadOnlyMRIAttribute)attribute).getRefreshProblem() != null) {
                return ((ReadOnlyMRIAttribute)attribute).getRefreshProblem();
            }
            Object val = ValueAccessor.getValue(attribute);
            if (val instanceof IQuantity) {
                return ((IQuantity)val).displayUsing("verbose");
            }
            return super.getToolTipTextTyped(attribute);
        }

        @Override
        protected Object getValue(IReadOnlyAttribute attribute) {
            return ValueAccessor.getValue(attribute);
        }
    }
}

