/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.IArray;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.ColorToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IAttributeStorage;
import com.jrockit.mc.rjmx.services.IAttributeStorageService;
import com.jrockit.mc.rjmx.services.MRIDataSeries;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.attributes.EditDisplayNameAction;
import com.jrockit.mc.rjmx.ui.column.TableColumnComposite;
import com.jrockit.mc.rjmx.ui.internal.AccessibleControlAction;
import com.jrockit.mc.rjmx.ui.internal.AddAttibutesAction;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.IAttributeSet;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.RemoveAttributeAction;
import com.jrockit.mc.rjmx.ui.internal.StatisticsCalculator;
import com.jrockit.mc.rjmx.ui.internal.StatisticsTable;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.MCArrayContentProvider;
import com.jrockit.mc.ui.misc.SWTColorToolkit;
import com.jrockit.mc.ui.rate.RateCoordinator;
import com.jrockit.mc.ui.rate.RateLimitedObserver;
import com.jrockit.mc.ui.rate.RefreshController;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import se.hirt.greychart.data.SeriesProviderSet;

public class CombinedChartSectionPart
extends MCClientSectionPart
implements IAttributeSet {
    private static final String ATTRIBUTE_ID = "attribute";
    private static final String ENABLED_ID = "enabled";
    private final IMRIMetaDataService mds;
    private final IMRIService mris;
    private final IAttributeStorageService m_storageService;
    private final Set<MRI> m_enabledAttributes = new HashSet<MRI>();
    private final SeriesProviderSet<ITimestampedData> m_dataProvider = new SeriesProviderSet();
    private final Map<MRI, IAttributeStorage> m_attributeStorages = new HashMap<MRI, IAttributeStorage>();
    private final MenuManager mm = new MenuManager();
    private TableColumnComposite m_statisticsTable;
    private ChartComposite chart;
    private CheckboxTableViewer legend;
    private AccessibleControlAction accessibleControlAction;
    private final RefreshController m_refreshController;
    private final RateCoordinator rateCoordinator;
    private final Observer chartDataObserver;
    private final Observer statisticsDataObserver;
    private final Observer metadataObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CombinedChartSectionPart.this.legend.getTable().isDisposed() && !CombinedChartSectionPart.this.chart.isDisposed()) {
                        CombinedChartSectionPart.this.updateQuantityKind(CombinedChartSectionPart.this.chart.getChartModel().getYAxis().getKindOfQuantity());
                        CombinedChartSectionPart.this.refreshAll();
                    }
                }
            });
        }
    };
    private final IArray<StatisticsCalculator> statisticsProvider = new IArray<StatisticsCalculator>(){

        public boolean isEmpty() {
            return CombinedChartSectionPart.this.m_attributeStorages.isEmpty();
        }

        public StatisticsCalculator[] elements() {
            StatisticsCalculator[] statisticsArray = new StatisticsCalculator[CombinedChartSectionPart.this.m_attributeStorages.size()];
            int i = 0;
            for (Map.Entry entry : CombinedChartSectionPart.this.m_attributeStorages.entrySet()) {
                MRI mri = (MRI)entry.getKey();
                StatisticsCalculator stats = new StatisticsCalculator(mri);
                stats.setUnit(UnitLookup.getUnitOrDefault((String)CombinedChartSectionPart.this.mds.getMetaData(mri).getUnitString()));
                long min = CombinedChartSectionPart.this.chart.getChart().getXAxis().getMin().longValue();
                long max = CombinedChartSectionPart.this.chart.getChart().getXAxis().getMax().longValue();
                for (MRIDataSeries ds : ((IAttributeStorage)entry.getValue()).getDataSeries()) {
                    Iterator it = ds.createIterator(min, max);
                    while (it.hasNext()) {
                        ITimestampedData data = (ITimestampedData)it.next();
                        long timestamp = (Long)data.getX();
                        if (min > timestamp || timestamp > max) continue;
                        stats.addValue(((Number)data.getY()).doubleValue());
                    }
                }
                statisticsArray[i++] = stats;
            }
            return statisticsArray;
        }
    };

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IMRIMetaDataService mds, IMRIService mris, IAttributeStorageService ss) {
        super(parent, toolkit, style, sectionIdentifier);
        this.mds = mds;
        this.mris = mris;
        this.m_storageService = ss;
        mds.addObserver(this.metadataObserver);
        this.m_refreshController = RefreshController.createGroup((Display)parent.getDisplay());
        this.rateCoordinator = new RateCoordinator();
        this.m_refreshController.add((IRefreshable)this.rateCoordinator);
        this.chartDataObserver = new RateLimitedObserver(this.rateCoordinator, 200){

            protected void doRefresh(Object arg) {
                if (!CombinedChartSectionPart.this.chart.isDisposed()) {
                    if (arg instanceof ITimestampedData) {
                        long timestamp = (Long)((ITimestampedData)arg).getX();
                        CombinedChartSectionPart.this.chart.extendsDataRangeToInclude(timestamp);
                    } else {
                        CombinedChartSectionPart.this.chart.refresh();
                    }
                }
            }
        };
        this.statisticsDataObserver = new RateLimitedObserver(this.rateCoordinator, 500){

            protected void doRefresh(Object arg) {
                if (!CombinedChartSectionPart.this.m_statisticsTable.isDisposed()) {
                    boolean visible = CombinedChartSectionPart.this.m_statisticsTable.isVisible();
                    TableViewer viewer = CombinedChartSectionPart.this.m_statisticsTable.getViewer();
                    Control control = viewer.getControl();
                    if (visible) {
                        control.setRedraw(false);
                    }
                    viewer.refresh();
                    if (visible) {
                        control.setRedraw(true);
                        control.update();
                    }
                }
            }
        };
    }

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IConnectionHandle connection) {
        this(parent, toolkit, style, sectionIdentifier, (IMRIMetaDataService)connection.getServiceOrDummy(IMRIMetaDataService.class), (IMRIService)connection.getServiceOrDummy(IMRIService.class), (IAttributeStorageService)connection.getServiceOrDummy(IAttributeStorageService.class));
    }

    protected Callback<Boolean> createEnableUpdatesCallback() {
        Action updatesAction = new Action(Messages.UpdatesAction_ACTION_NAME, 2){

            public void run() {
                CombinedChartSectionPart.this.chart.setUpdatesEnabled(this.isChecked());
                if (this.isChecked()) {
                    CombinedChartSectionPart.this.m_refreshController.start();
                } else {
                    CombinedChartSectionPart.this.m_refreshController.stop();
                }
            }
        };
        updatesAction.setChecked(false);
        updatesAction.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab_grey.gif"));
        updatesAction.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
        updatesAction.setToolTipText(Messages.UpdatesAction_TOOLTIP_TEXT);
        updatesAction.setId("toggle.freeze");
        this.getMCToolBarManager().add((IAction)updatesAction);
        return new Callback<Boolean>((IAction)updatesAction){
            private final /* synthetic */ IAction val$updatesAction;
            {
                this.val$updatesAction = iAction;
            }

            public void call(Boolean enableUpdates) {
                CombinedChartSectionPart.this.chart.setUpdatesEnabled(enableUpdates);
                this.val$updatesAction.setChecked(enableUpdates.booleanValue());
                CombinedChartSectionPart.this.getMCToolBarManager().update();
                if (enableUpdates.booleanValue()) {
                    CombinedChartSectionPart.this.m_refreshController.start();
                } else {
                    CombinedChartSectionPart.this.m_refreshController.stop();
                }
            }
        };
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        Composite stackContainer = formToolkit.createComposite(section);
        final StackLayout stackLayout = new StackLayout();
        stackContainer.setLayout((Layout)stackLayout);
        final Composite chartContainer = formToolkit.createComposite(stackContainer);
        chartContainer.setLayout((Layout)new GridLayout(2, false));
        this.m_statisticsTable = StatisticsTable.create(stackContainer, new AttributeLabelProvider(this.mds, this.mris), this, false);
        this.m_statisticsTable.getViewer().setInput(this.statisticsProvider);
        this.chart = new ChartComposite(chartContainer, 0, this.createEnableUpdatesCallback(), this.mds);
        this.chart.setLayoutData(new GridData(4, 4, true, true));
        this.chart.showLast(60000000000L);
        this.chart.getChart().setDataProvider(this.m_dataProvider);
        this.chart.getChartModel().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                CombinedChartSectionPart.this.getSection().setText(CombinedChartSectionPart.this.chart.getChartModel().getChartTitle());
                CombinedChartSectionPart.this.chart.refresh();
            }
        });
        this.createLegend(formToolkit, chartContainer);
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction(this.mds, this.mris, this){

            @Override
            protected ContentType<?> getContentType() {
                return CombinedChartSectionPart.this.isEmpty() ? null : CombinedChartSectionPart.this.chart.getChartModel().getYAxis().getKindOfQuantity();
            }

            @Override
            protected boolean allowMultiple() {
                return !CombinedChartSectionPart.this.isEmpty();
            }
        }, 0);
        this.accessibleControlAction = new AccessibleControlAction(){

            public void run() {
                stackLayout.topControl = this.isChecked() ? CombinedChartSectionPart.this.m_statisticsTable : chartContainer;
                CombinedChartSectionPart.this.m_statisticsTable.setVisible(this.isChecked());
                chartContainer.setVisible(!this.isChecked());
                CombinedChartSectionPart.this.refreshAll();
            }
        };
        this.getMCToolBarManager().add((IAction)this.accessibleControlAction);
        return stackContainer;
    }

    public void dispose() {
        this.m_refreshController.stop();
        this.mm.dispose();
        for (IAttributeStorage as : this.m_attributeStorages.values()) {
            as.deleteObserver(this.statisticsDataObserver);
            as.deleteObserver(this.chartDataObserver);
        }
        if (this.accessibleControlAction != null) {
            this.accessibleControlAction.dispose();
        }
        this.mds.deleteObserver(this.metadataObserver);
        super.dispose();
    }

    public void saveState(IMemento state) {
        this.chart.getChartModel().saveState(state);
        for (MRI mri : this.m_attributeStorages.keySet()) {
            IMemento child = state.createChild(ATTRIBUTE_ID);
            child.putTextData(mri.getQualifiedName());
            child.putBoolean(ENABLED_ID, this.isEnabled(mri));
        }
    }

    public void restoreState(IMemento state) {
        this.chart.getChartModel().restoreState(state);
        HashSet<MRI> current = new HashSet<MRI>(this.m_attributeStorages.keySet());
        IMemento[] iMementoArray = state.getChildren(ATTRIBUTE_ID);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            MRI mri = MRI.createFromQualifiedName((String)child.getTextData().trim());
            current.remove(mri);
            this.doAdd(mri);
            Boolean enabled = child.getBoolean(ENABLED_ID);
            this.setEnabled(mri, enabled == null || enabled != false);
            ++n2;
        }
        if (!this.m_enabledAttributes.isEmpty()) {
            this.setQuantityKindFromAttribute(this.m_enabledAttributes.iterator().next());
        }
        for (MRI mri : current) {
            this.doRemove(mri);
        }
        this.refreshAll();
    }

    public ChartComposite getChart() {
        return this.chart;
    }

    protected void initializeSection(Section section) {
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.doAdd(mri);
            ++n2;
        }
        if (mris.length > 0) {
            this.setQuantityKindFromAttribute(mris[0]);
        }
        this.refreshAll();
    }

    private void doAdd(MRI mri) {
        IAttributeStorage storage = this.m_storageService.getAttributeStorage(mri);
        if (storage != null) {
            storage.addObserver(this.chartDataObserver);
            storage.addObserver(this.statisticsDataObserver);
            this.m_attributeStorages.put(mri, storage);
            this.doSetEnabled(mri, storage, true);
        }
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.doRemove(mri);
            ++n2;
        }
        this.refreshAll();
    }

    private void doRemove(MRI mri) {
        IAttributeStorage storage = this.m_attributeStorages.remove(mri);
        if (storage != null) {
            storage.deleteObserver(this.statisticsDataObserver);
            storage.deleteObserver(this.chartDataObserver);
            this.doSetEnabled(mri, storage, false);
        }
    }

    private void setEnabled(MRI mri, boolean enabled) {
        IAttributeStorage storage = this.m_attributeStorages.get(mri);
        if (storage != null && this.isEnabled(mri) != enabled) {
            this.doSetEnabled(mri, storage, enabled);
        }
    }

    private void doSetEnabled(MRI mri, IAttributeStorage storage, boolean enabled) {
        if (enabled) {
            this.m_enabledAttributes.add(mri);
            this.m_dataProvider.addDataSeries(storage.getDataSeries());
        } else {
            this.m_enabledAttributes.remove(mri);
            this.m_dataProvider.removeDataSeries(storage.getDataSeries());
        }
    }

    private boolean isEnabled(MRI attributeDescriptor) {
        return this.m_enabledAttributes.contains(attributeDescriptor);
    }

    public MRI[] elements() {
        return this.m_attributeStorages.keySet().toArray(new MRI[this.m_attributeStorages.keySet().size()]);
    }

    public boolean isEmpty() {
        return this.m_attributeStorages.isEmpty();
    }

    private void refreshAll() {
        this.updateDataRange();
        this.chart.refresh();
        if (this.m_statisticsTable.isVisible()) {
            this.m_statisticsTable.getViewer().refresh();
        } else {
            this.legend.refresh();
        }
    }

    private void updateDataRange() {
        long dataStart = Long.MAX_VALUE;
        long dataEnd = Long.MIN_VALUE;
        for (MRI enabledAttribute : this.m_enabledAttributes) {
            IAttributeStorage storage = this.m_attributeStorages.get(enabledAttribute);
            dataStart = Math.min(dataStart, storage.getDataStart());
            dataEnd = Math.max(dataEnd, storage.getDataEnd());
        }
        this.chart.setDataRange(dataStart, dataEnd);
    }

    private void createLegend(FormToolkit formToolkit, Composite container) {
        Table table = formToolkit.createTable(container, 65570);
        this.legend = new CheckboxTableViewer(table);
        this.legend.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MRI mri = (MRI)event.getElement();
                boolean enable = event.getChecked();
                CombinedChartSectionPart.this.setEnabled(mri, enable);
                if (enable) {
                    CombinedChartSectionPart.this.setQuantityKindFromAttribute(mri);
                }
                CombinedChartSectionPart.this.refreshAll();
            }
        });
        this.legend.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return CombinedChartSectionPart.this.isEnabled((MRI)element);
            }
        });
        this.legend.setComparator(new ViewerComparator());
        this.legend.setContentProvider((IContentProvider)MCArrayContentProvider.INSTANCE);
        this.legend.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(this.mds, this.mris));
        this.legend.setInput((Object)this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.legend);
        GridData gd2 = new GridData(4, 4, false, true);
        gd2.heightHint = 60;
        gd2.widthHint = 210;
        table.setLayoutData((Object)gd2);
        RemoveAttributeAction removeAction = new RemoveAttributeAction((ISelectionProvider)this.legend, this);
        this.mm.add((IAction)removeAction);
        InFocusHandlerActivator.install((Control)this.legend.getControl(), (IAction)removeAction);
        this.mm.add((IContributionItem)new Separator());
        this.mm.add((IAction)new EditDisplayNameAction(this.mds, (ISelectionProvider)this.legend));
        SelectionProviderAction editColorAction = new SelectionProviderAction((ISelectionProvider)this.legend, Messages.ChartSectionPart_EDIT_COLOR_TEXT){

            public void run() {
                CombinedChartSectionPart.this.editColor((MRI)this.getStructuredSelection().getFirstElement());
            }

            public void selectionChanged(IStructuredSelection selection) {
                this.setEnabled(selection.size() == 1);
            }
        };
        editColorAction.setEnabled(false);
        this.mm.add((IAction)editColorAction);
        this.legend.getTable().setMenu(this.mm.createContextMenu((Control)this.legend.getTable()));
    }

    private void editColor(MRI descriptor) {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        RGB rgb = SWTColorToolkit.asRGB((Color)MRIMetaDataToolkit.getColor((IMRIMetaDataProvider)this.mds.getMetaData(descriptor)));
        dialog.setRGB(rgb);
        RGB newRGB = dialog.open();
        if (newRGB != null) {
            String colorAsString = ColorToolkit.encode((Color)new Color(newRGB.red, newRGB.green, newRGB.blue));
            this.mds.setMetaData(descriptor, "color", (Object)colorAsString);
        }
    }

    private void setQuantityKindFromAttribute(MRI attribute) {
        KindOfQuantity kind = UnitLookup.getUnitOrDefault((String)this.mds.getMetaData(attribute).getUnitString()).getContentType();
        if (!this.chart.getChartModel().getYAxis().getKindOfQuantity().equals((Object)kind)) {
            this.chart.getChartModel().getYAxis().setKindOfQuantity(kind);
            this.chart.getChartModel().getYAxis().notifyObservers();
        }
        this.updateQuantityKind(kind);
    }

    private void updateQuantityKind(KindOfQuantity<?> currentKind) {
        for (MRI mri : this.m_attributeStorages.keySet()) {
            IUnit unit = UnitLookup.getUnitOrDefault((String)this.mds.getMetaData(mri).getUnitString());
            if (currentKind.equals((Object)unit.getContentType())) continue;
            this.setEnabled(mri, false);
        }
    }
}

