/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class MBeanPropertiesOrderer {
    private static ArrayList<String> propertyKeyPrefixOrderList;
    private static ArrayList<String> propertyKeySuffixOrderList;
    private static boolean propertiesInAlphabeticOrder;
    private static boolean caseInsensitivePropertyKeys;
    private static boolean showCompressedPaths;
    private static HashSet<IMBeanPropertiesOrderChangedListener> propertiesOrderChangeListeners;

    static {
        MBeanPropertiesOrderer.updatePrefixOrderString();
        MBeanPropertiesOrderer.updateSuffixOrderString();
        MBeanPropertiesOrderer.updatePropertiesInAlpabeticOrder();
        MBeanPropertiesOrderer.updateCaseInsensitivePropertyKeys();
        MBeanPropertiesOrderer.updateShowCompressedPaths();
        propertiesOrderChangeListeners = new HashSet();
        RJMXUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("console.ui.mbeanbrowser.propertyKeyList")) {
                    MBeanPropertiesOrderer.updatePrefixOrderString();
                    MBeanPropertiesOrderer.firePropertiesOrderChangedEvent(event);
                } else if (property.equals("console.ui.mbeanbrowser.suffixPropertyKeyList")) {
                    MBeanPropertiesOrderer.updateSuffixOrderString();
                    MBeanPropertiesOrderer.firePropertiesOrderChangedEvent(event);
                } else if (property.equals("console.ui.mbeanbrowser.propertiesInAlphabeticOrder")) {
                    MBeanPropertiesOrderer.updatePropertiesInAlpabeticOrder();
                    MBeanPropertiesOrderer.firePropertiesOrderChangedEvent(event);
                } else if (property.equals("console.ui.mbeanbrowser.caseInsensitivePropertyOrder")) {
                    MBeanPropertiesOrderer.updateCaseInsensitivePropertyKeys();
                    MBeanPropertiesOrderer.firePropertiesOrderChangedEvent(event);
                } else if (property.equals("console.ui.mbeanbrowser.showCompressedPaths")) {
                    MBeanPropertiesOrderer.updateShowCompressedPaths();
                    MBeanPropertiesOrderer.firePropertiesOrderChangedEvent(event);
                }
            }
        });
    }

    private MBeanPropertiesOrderer() {
    }

    private static synchronized void updatePrefixOrderString() {
        String prefixOrderString = RJMXUIPlugin.getDefault().getPreferenceStore().getString("console.ui.mbeanbrowser.propertyKeyList");
        propertyKeyPrefixOrderList = new ArrayList();
        MBeanPropertiesOrderer.splitCommaSeparatedKeyString(propertyKeyPrefixOrderList, prefixOrderString);
    }

    private static synchronized void updateSuffixOrderString() {
        String suffixOrderString = RJMXUIPlugin.getDefault().getPreferenceStore().getString("console.ui.mbeanbrowser.suffixPropertyKeyList");
        propertyKeySuffixOrderList = new ArrayList();
        MBeanPropertiesOrderer.splitCommaSeparatedKeyString(propertyKeySuffixOrderList, suffixOrderString);
    }

    private static synchronized void updatePropertiesInAlpabeticOrder() {
        propertiesInAlphabeticOrder = RJMXUIPlugin.getDefault().getPreferenceStore().getBoolean("console.ui.mbeanbrowser.propertiesInAlphabeticOrder");
    }

    private static synchronized void updateCaseInsensitivePropertyKeys() {
        caseInsensitivePropertyKeys = RJMXUIPlugin.getDefault().getPreferenceStore().getBoolean("console.ui.mbeanbrowser.caseInsensitivePropertyOrder");
    }

    private static synchronized void updateShowCompressedPaths() {
        showCompressedPaths = RJMXUIPlugin.getDefault().getPreferenceStore().getBoolean("console.ui.mbeanbrowser.showCompressedPaths");
    }

    private static void splitCommaSeparatedKeyString(List<String> list, String str) {
        int next;
        int last = 0;
        while ((next = str.indexOf(44, last)) >= 0) {
            if (next > last) {
                list.add(MBeanPropertiesOrderer.comparableKey(str.substring(last, next)));
            }
            last = next + 1;
        }
        if (last + 1 < str.length()) {
            list.add(MBeanPropertiesOrderer.comparableKey(str.substring(last)));
        }
    }

    private static String comparableKey(String key) {
        return caseInsensitivePropertyKeys ? key.toLowerCase() : key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertiesOrderChangedListener(IMBeanPropertiesOrderChangedListener listener) {
        HashSet<IMBeanPropertiesOrderChangedListener> hashSet = propertiesOrderChangeListeners;
        synchronized (hashSet) {
            propertiesOrderChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertiesOrderChangedListener(IMBeanPropertiesOrderChangedListener listener) {
        HashSet<IMBeanPropertiesOrderChangedListener> hashSet = propertiesOrderChangeListeners;
        synchronized (hashSet) {
            propertiesOrderChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePropertiesOrderChangedEvent(PropertyChangeEvent e) {
        HashSet<IMBeanPropertiesOrderChangedListener> hashSet = propertiesOrderChangeListeners;
        synchronized (hashSet) {
            for (IMBeanPropertiesOrderChangedListener imBeanPropertiesOrderChangedListener : propertiesOrderChangeListeners) {
                imBeanPropertiesOrderChangedListener.propertiesOrderChanged(e);
            }
        }
    }

    public static String getMBeanPath(ObjectName bean) {
        StringBuffer path = new StringBuffer();
        path.append(bean.getDomain());
        Property[] properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
        int i = 0;
        while (i < properties.length) {
            path.append(i == 0 ? (char)':' : ',');
            if (!showCompressedPaths) {
                path.append(properties[i].getKey());
                path.append('=');
            }
            path.append(properties[i].getValue());
            ++i;
        }
        return path.toString();
    }

    public static String getAttributePath(MRI attributeDescriptor) {
        StringBuffer path = new StringBuffer(MBeanPropertiesOrderer.getMBeanPath(attributeDescriptor.getObjectName()));
        path.append('/');
        path.append(attributeDescriptor.getDataPath());
        return path.toString();
    }

    public static Property[] getOrderedProperties(ObjectName bean) {
        Property property;
        List<Property> propertiesList = MBeanPropertiesOrderer.getProperties(bean);
        Property[] properties = new Property[propertiesList.size()];
        int insertPos = 0;
        int pre = 0;
        while (pre < propertyKeyPrefixOrderList.size()) {
            String prefixKey = propertyKeyPrefixOrderList.get(pre);
            int prop = 0;
            while (prop < propertiesList.size()) {
                property = propertiesList.get(prop);
                if (property != null && MBeanPropertiesOrderer.comparableKey(property.getKey()).equals(prefixKey)) {
                    properties[insertPos] = property;
                    ++insertPos;
                    propertiesList.set(prop, null);
                }
                ++prop;
            }
            ++pre;
        }
        int lastInsertPos = properties.length;
        if (insertPos < lastInsertPos) {
            int suf = propertyKeySuffixOrderList.size() - 1;
            while (suf >= 0) {
                String suffixKey = propertyKeySuffixOrderList.get(suf);
                int prop = propertiesList.size() - 1;
                while (prop >= 0) {
                    Property property2 = propertiesList.get(prop);
                    if (property2 != null && MBeanPropertiesOrderer.comparableKey(property2.getKey()).equals(suffixKey)) {
                        properties[--lastInsertPos] = property2;
                        propertiesList.set(prop, null);
                    }
                    --prop;
                }
                --suf;
            }
        }
        if (insertPos < lastInsertPos) {
            int startInsertPos = insertPos;
            int i = 0;
            while (i < propertiesList.size()) {
                property = propertiesList.get(i);
                if (property != null) {
                    properties[insertPos] = property;
                    ++insertPos;
                }
                ++i;
            }
            if (propertiesInAlphabeticOrder && insertPos - startInsertPos > 1) {
                Arrays.sort(properties, startInsertPos, lastInsertPos, new Comparator<Property>(){

                    @Override
                    public int compare(Property first, Property second) {
                        return MBeanPropertiesOrderer.comparableKey(first.getKey()).compareTo(MBeanPropertiesOrderer.comparableKey(second.getKey()));
                    }
                });
            }
        }
        Property property3 = properties[properties.length - 1];
        properties[properties.length - 1] = new PropertyWithMBean(property3.getKey(), property3.getValue(), bean);
        return properties;
    }

    private static List<Property> getProperties(ObjectName bean) {
        ArrayList<Property> propertiesList = new ArrayList<Property>();
        String propertiesString = bean.getKeyPropertyListString();
        Hashtable<String, String> bar = bean.getKeyPropertyList();
        Hashtable<String, String> propertiesTable = new Hashtable<String, String>(bar);
        int index = propertiesString.indexOf(61);
        while (index != -1) {
            String key = propertiesString.substring(0, index);
            String value = propertiesTable.get(key);
            propertiesTable.remove(key);
            int endValueIndex = index + 1 + value.length();
            int nextIndex = propertiesString.indexOf(44, endValueIndex);
            propertiesString = nextIndex != -1 ? propertiesString.substring(nextIndex + 1) : propertiesString.substring(propertiesString.length());
            index = propertiesString.indexOf(61);
            propertiesList.add(new Property(key, value));
        }
        return propertiesList;
    }

    public static interface IMBeanPropertiesOrderChangedListener {
        public void propertiesOrderChanged(PropertyChangeEvent var1);
    }

    public static class Property {
        private final String key;
        private final String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getStringRepresentation() {
            return String.valueOf(this.key) + '=' + this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                Property that = (Property)obj;
                return this.key.equals(that.key) && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.getStringRepresentation().hashCode();
        }

        public String toString() {
            return String.valueOf(super.toString()) + '[' + this.getStringRepresentation() + ']';
        }
    }

    public static class PropertyWithMBean
    extends Property
    implements IAdaptable {
        private final ObjectName bean;

        public PropertyWithMBean(String key, String value, ObjectName bean) {
            super(key, value);
            this.bean = bean;
        }

        public ObjectName getBean() {
            return this.bean;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof PropertyWithMBean) {
                PropertyWithMBean that = (PropertyWithMBean)obj;
                return super.equals(that) && this.bean.equals(that.bean);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.bean.hashCode();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ObjectName.class) {
                return this.getBean();
            }
            return null;
        }
    }
}

