/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.core.output2.NbIOProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class OutputKeymapManager
extends KeymapManager {
    private static final Logger LOG = Logger.getLogger(OutputKeymapManager.class.getName());
    private static final String CATEGORY_NAME = NbBundle.getMessage(NbIOProvider.class, (String)"OpenIDE-Module-Name");
    public static final String CLEAR_ACTION_ID = "output-window-clear";
    public static final String FILTER_ACTION_ID = "output-window-filter";
    public static final String LARGER_FONT_ACTION_ID = "output-window-larger-font";
    public static final String SMALLER_FONT_ACTION_ID = "output-window-smaller-font";
    public static final String CLOSE_ACTION_ID = "output-window-close";
    public static final String OUTPUT_SETTINGS_ACTION_ID = "output-window-settings";
    public static final String SAVE_AS_ACTION_ID = "output-window-save-as";
    public static final String WRAP_ACTION_ID = "output-window-wrap";
    public static final String STORAGE_DIR = "org-netbeans-core-output2/actions/";
    public static final String SHORTCUT_PREFIX = "sc";
    private final OutWinShortCutAction wrap = new OutWinShortCutAction("output-window-wrap", "ACTION_WRAP");
    private final OutWinShortCutAction clear = new OutWinShortCutAction("output-window-clear", "ACTION_CLEAR");
    private final OutWinShortCutAction filter = new OutWinShortCutAction("output-window-filter", "ACTION_FILTER");
    private final OutWinShortCutAction largerFont = new OutWinShortCutAction("output-window-larger-font", "ACTION_LARGER_FONT");
    private final OutWinShortCutAction smallerFont = new OutWinShortCutAction("output-window-smaller-font", "ACTION_SMALLER_FONT");
    private final OutWinShortCutAction closeWindow = new OutWinShortCutAction("output-window-close", "ACTION_CLOSE");
    private final OutWinShortCutAction fontType = new OutWinShortCutAction("output-window-settings", "ACTION_SETTINGS");
    private final OutWinShortCutAction saveAs = new OutWinShortCutAction("output-window-save-as", "ACTION_SAVEAS");
    Map<String, Map<ShortcutAction, Set<String>>> keymaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    Map<ShortcutAction, Set<String>> defaultKeymap = new HashMap<ShortcutAction, Set<String>>();
    private final Set<OutWinShortCutAction> allActions = new HashSet<OutWinShortCutAction>();
    Map<String, Set<ShortcutAction>> actions = new HashMap<String, Set<ShortcutAction>>();

    public OutputKeymapManager() {
        super("OutputWindowKeymapManager");
        Collections.addAll(this.allActions, this.wrap, this.clear, this.filter, this.largerFont, this.smallerFont, this.closeWindow, this.fontType, this.saveAs);
        HashSet<OutWinShortCutAction> hashSet = new HashSet<OutWinShortCutAction>();
        hashSet.addAll(this.allActions);
        this.actions.put(CATEGORY_NAME, hashSet);
        this.fillDefaultKeyMap();
        this.loadShortCuts();
    }

    private void fillDefaultKeyMap() {
        Iterator<OutWinShortCutAction> iterator = this.allActions.iterator();
        while (iterator.hasNext()) {
            OutWinShortCutAction outWinShortCutAction;
            String string = (outWinShortCutAction = iterator.next()).getDefaultShortcut();
            this.defaultKeymap.put(outWinShortCutAction, string != null && !string.isEmpty() ? Collections.singleton(string) : Collections.emptySet());
        }
    }

    public Map<String, Set<ShortcutAction>> getActions() {
        return this.actions;
    }

    public void refreshActions() {
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        Map<ShortcutAction, Set<String>> map = this.keymaps.get(string);
        if (map == null) {
            map = new HashMap<ShortcutAction, Set<String>>(this.defaultKeymap);
            this.keymaps.put(string, map);
        }
        return map;
    }

    public Map<ShortcutAction, Set<String>> getDefaultKeymap(String string) {
        return this.defaultKeymap;
    }

    public void saveKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        HashMap<OutWinShortCutAction, Set<String>> hashMap = new HashMap<OutWinShortCutAction, Set<String>>();
        this.keymaps.put(string, hashMap);
        for (OutWinShortCutAction outWinShortCutAction : this.allActions) {
            Set<String> set = map.get(outWinShortCutAction);
            if (set == null) {
                set = Collections.emptySet();
            }
            hashMap.put(outWinShortCutAction, set);
        }
        this.storeShortCuts(string);
    }

    public List<String> getProfiles() {
        return null;
    }

    public String getCurrentProfile() {
        return null;
    }

    public void setCurrentProfile(String string) {
    }

    public void deleteProfile(String string) {
    }

    public boolean isCustomProfile(String string) {
        return false;
    }

    private void storeShortCuts(String string) {
        FileObject fileObject = FileUtil.getConfigRoot();
        try {
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)(STORAGE_DIR + string));
            for (OutWinShortCutAction outWinShortCutAction : this.allActions) {
                FileObject fileObject3 = fileObject2.getFileObject(outWinShortCutAction.getId());
                if (fileObject3 == null) {
                    fileObject3 = fileObject2.createData(outWinShortCutAction.getId());
                } else if (fileObject3.isFolder()) {
                    throw new IOException(fileObject3 + " is a folder.");
                }
                Enumeration enumeration = fileObject3.getAttributes();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    fileObject3.setAttribute(string2, null);
                }
                int n = 1;
                if (this.keymaps.get(string).get(outWinShortCutAction) == null) continue;
                for (String string3 : this.keymaps.get(string).get(outWinShortCutAction)) {
                    fileObject3.setAttribute(SHORTCUT_PREFIX + n++, (Object)string3);
                }
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Cannot create folder", iOException);
        }
    }

    private void loadShortCuts() {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject(STORAGE_DIR);
        if (fileObject2 == null) {
            return;
        }
        for (FileObject fileObject3 : fileObject2.getChildren()) {
            if (!fileObject3.isFolder()) continue;
            HashMap<OutWinShortCutAction, Set<Object>> hashMap = new HashMap<OutWinShortCutAction, Set<Object>>();
            this.keymaps.put(fileObject3.getName(), hashMap);
            for (OutWinShortCutAction outWinShortCutAction : this.allActions) {
                FileObject fileObject4 = fileObject3.getFileObject(outWinShortCutAction.getId());
                if (fileObject4 == null || !fileObject4.isData()) {
                    hashMap.put(outWinShortCutAction, Collections.emptySet());
                    continue;
                }
                Enumeration enumeration = fileObject4.getAttributes();
                HashSet<String> hashSet = new HashSet<String>();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.startsWith(SHORTCUT_PREFIX)) continue;
                    hashSet.add((String)fileObject4.getAttribute(string));
                }
                hashMap.put(outWinShortCutAction, hashSet);
            }
        }
    }

    private class OutWinShortCutAction
    implements ShortcutAction {
        private String id;
        private String bundleKey;
        private String displayName;
        private String defaultShortcut;

        public OutWinShortCutAction(String string, String string2) {
            String string3;
            this.id = string;
            this.bundleKey = string2;
            this.displayName = NbBundle.getMessage(NbIOProvider.class, (String)string2);
            String string4 = Utilities.isMac() ? string2 + ".accel.mac" : string2 + ".accel";
            this.defaultShortcut = string3 = NbBundle.getMessage(NbIOProvider.class, (String)string4);
        }

        public String getId() {
            return this.id;
        }

        public String getBundleKey() {
            return this.bundleKey;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDefaultShortcut() {
            return this.defaultShortcut;
        }

        public String getDelegatingActionId() {
            return null;
        }

        public ShortcutAction getKeymapManagerInstance(String string) {
            return null;
        }
    }
}

