/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.common;

import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.SelectionIteratorFactory;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public final class OperativeSetService {
    private volatile Iterable<IEvent> m_iteratorFactory;
    private ITimeRange m_range;
    private final IServiceLocator m_serviceLocator;

    public OperativeSetService(IServiceLocator serviceLocator) {
        this.m_serviceLocator = serviceLocator;
        this.m_iteratorFactory = new SelectionIteratorFactory((IStructuredSelection)new StructuredSelection());
    }

    public void setEventFactory(Iterable<IEvent> iterable) {
        this.m_iteratorFactory = iterable;
    }

    public Iterable<IEvent> getEventFactory() {
        return this.m_iteratorFactory;
    }

    public void setEventSelection(IStructuredSelection s) {
        this.m_iteratorFactory = new SelectionIteratorFactory(s);
    }

    public ITimeRange getSelectedRange() {
        return this.m_range;
    }

    public void setSelectedRange(ITimeRange range) {
        this.m_range = range;
    }

    public void notifyOperativeSetAware() {
        UIScope components = (UIScope)this.m_serviceLocator.getService(UIScope.class);
        for (IOperativeSetAware oa : components.getTopScope().getCompatiblesWithChildren(IOperativeSetAware.class)) {
            oa.operativeSetChange();
        }
    }

    public Iterable<IEvent> getAllEventsInSelectedRange() {
        return new Iterable<IEvent>(){

            @Override
            public Iterator<IEvent> iterator() {
                IView view = OperativeSetService.this.getRecording().createView();
                view.setRange(OperativeSetService.this.m_range);
                return view.iterator();
            }
        };
    }

    public Iterable<IEvent> getAllEvents() {
        return new Iterable<IEvent>(){

            @Override
            public Iterator<IEvent> iterator() {
                return OperativeSetService.this.getRecording().createView().iterator();
            }
        };
    }

    public FlightRecording getRecording() {
        return (FlightRecording)this.m_serviceLocator.getService(FlightRecording.class);
    }
}

