/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SelectionVisitor
implements IVisitor {
    private final ITimeRange m_range;
    private final IEventFilter m_rangeFilter;
    private final List<IEvent> m_selection = new ArrayList<IEvent>(1000);

    public SelectionVisitor(ITimeRange range, IEventFilter filter) {
        this.m_range = range;
        this.m_rangeFilter = filter;
    }

    @Override
    public boolean visit(UIThreadGroup uiThreadGroup) {
        boolean result = false;
        Iterator<UIThread> it = uiThreadGroup.getThreads().iterator();
        while (it.hasNext()) {
            if (!this.visit(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visit(UIThread uiTHread) {
        boolean result = false;
        Iterator<UITrack> it = uiTHread.getTracks().iterator();
        while (it.hasNext()) {
            if (!this.visit(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visit(UITrack uiTrack) {
        boolean result = false;
        Iterator<IEvent> it = uiTrack.iterator(this.m_rangeFilter, this.m_range, Expansion.NORMAL);
        while (it.hasNext()) {
            if (!this.visit(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visit(UIGarbageCollector uiGarbageCollector) {
        boolean result = false;
        Iterator<UITrack> it = uiGarbageCollector.getTracks().iterator();
        while (it.hasNext()) {
            if (!this.visit(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visit(IEvent event) {
        if (this.m_rangeFilter.accept(event)) {
            this.m_selection.add(event);
            return true;
        }
        return false;
    }

    public void clear() {
        this.m_selection.clear();
    }

    public List<IEvent> getSelection() {
        return this.m_selection;
    }
}

