/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.ui.AbstractFlightRecordingEditor;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.MessagePage2;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeTreePage;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class EventTypesView
extends PageBookView
implements IPageChangedListener {
    public static final String ID = "com.jrockit.mc.flightrecorder.ui.views.types.EventTypesView";
    private AbstractFlightRecordingEditor m_lastEditor;
    private final Set<Integer> viewShownFor = new HashSet<Integer>();

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof AbstractFlightRecordingEditor) {
            if (this.m_lastEditor != null) {
                this.m_lastEditor.removePageChangedListener(this);
                this.m_lastEditor = null;
            }
            this.m_lastEditor = (AbstractFlightRecordingEditor)part;
            this.m_lastEditor.addPageChangedListener(this);
            this.updateShowingPage();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.m_lastEditor != null) {
            this.m_lastEditor.removePageChangedListener(this);
            this.m_lastEditor = null;
        }
        super.partDeactivated(part);
    }

    private void updateShowingPage() {
        if (this.m_lastEditor != null && this.activeTabHandlesTypChange()) {
            super.partActivated((IWorkbenchPart)this.m_lastEditor);
            if (this.viewShownFor.add(((Object)((Object)this.m_lastEditor)).hashCode())) {
                this.showView();
            }
        } else {
            super.partActivated(null);
        }
    }

    private void showView() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = EventTypesView.this.getSite().getWorkbenchWindow().getActivePage();
                    if (page != null) {
                        page.showView(EventTypesView.ID, null, 2);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    private boolean activeTabHandlesTypChange() {
        UIScope tabScope;
        IServiceLocator sl;
        IEditorPart activeEditor = this.m_lastEditor.getActiveEditor();
        if (activeEditor instanceof DesignerTab && (sl = ((DesignerTab)activeEditor).getServiceLocator()) != null && (tabScope = (UIScope)sl.getService(UIScope.class)) != null) {
            for (ITypeVisibilityChange change : tabScope.getCompatiblesWithChildren(ITypeVisibilityChange.class)) {
                if (!change.isTypeChangeEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage2 mp = new MessagePage2();
        mp.setMessage(Messages.TYPE_COMPONENT_NONE_FILTERABLE_TAB_TEXT);
        this.initPage((IPageBookViewPage)mp);
        mp.createControl((Composite)book);
        return mp;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        AbstractFlightRecordingEditor editor;
        if (part instanceof AbstractFlightRecordingEditor && (editor = (AbstractFlightRecordingEditor)part).isLoadDone()) {
            IServiceLocator sl = editor.getServiceLocator();
            TypeRespository typeRepo = (TypeRespository)sl.getService(TypeRespository.class);
            UIScope flrEditorScope = (UIScope)sl.getService(UIScope.class);
            if (flrEditorScope != null && typeRepo != null) {
                TypeTreePage p = new TypeTreePage(typeRepo, flrEditorScope);
                this.initPage((IPageBookViewPage)p);
                p.createControl((Composite)this.getPageBook());
                return new PageBookView.PageRec(part, (IPage)p);
            }
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (part instanceof DesignEditor) {
            pageRecord.page.dispose();
            pageRecord.dispose();
        }
    }

    public void dispose() {
        if (this.m_lastEditor != null) {
            this.m_lastEditor.removePageChangedListener(this);
        }
        this.m_lastEditor = null;
        super.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part;
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        if (page != null && this.isImportant((IWorkbenchPart)(part = page.getActiveEditor()))) {
            return part;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part == null || part instanceof AbstractFlightRecordingEditor;
    }

    public void pageChanged(PageChangedEvent event) {
        this.updateShowingPage();
    }
}

