/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JVMBrowserPlugin;
import com.jrockit.mc.browser.wizards.Messages;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.model.internal.ServerModel;
import com.jrockit.mc.ui.wizards.SimpleImportFromFileWizardPage;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;

public class ConnectionImportWizard
extends Wizard
implements IImportWizard {
    private SimpleImportFromFileWizardPage m_wizardPage;

    public boolean performFinish() {
        File file = this.m_wizardPage.getFile();
        if (file != null) {
            try {
                Document doc = XmlToolkit.loadDocumentFromFile((File)file);
                ((ServerModel)RJMXPlugin.getDefault().getService(ServerModel.class)).importServers(doc);
                this.m_wizardPage.storeFilename();
                return true;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConnectionImportWizard_ERROR_IMPORTING_CONNECTIONS_TITLE, (String)MessageFormat.format(Messages.ConnectionImportWizard_ERROR_IMPORTING_FROM_FILE_X_TEXT, file.toString()), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(JVMBrowserPlugin.getDefault().getDialogSettings());
        this.m_wizardPage = new SimpleImportFromFileWizardPage(Messages.ConnectionImportWizard_IMPORT_CONNECTION_WIZARD_NAME, "xml");
        this.m_wizardPage.setTitle(Messages.ConnectionImportWizard_IMPORTCONNECTIONS_TITLE);
        this.m_wizardPage.setMessage(Messages.ConnectionImportWizard_SELECT_CONNECTION_FILE_FOR_IMPORT_TEXT);
        this.m_wizardPage.setImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
        this.addPage((IWizardPage)this.m_wizardPage);
    }
}

