/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.TableColumnSortManager;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.Messages;
import com.jrockit.mc.ui.model.fields.IFieldUI;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableSettingsDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private final IFieldUI[] m_fields;
    private Text m_minWidthText;
    private Text m_weightText;
    private Button m_inintialSortOrder;
    private IFieldUI m_lastField;
    private CheckboxTableViewer m_tableViewer;
    private final boolean showSortOrderSetting;

    public TableSettingsDialog(Shell parentShell, IFieldUI[] fields, boolean showSortOrderSetting) {
        super(parentShell);
        this.m_fields = fields;
        this.showSortOrderSetting = showSortOrderSetting;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.TableSettingsDialog_TABLE_SETTINGS_TITLE);
        this.setMessage(Messages.TableSettingsDialog_TABLE_SETTINGS_DESCRIPTION_TEXT);
        this.setTitleImage(UIPlugin.getDefault().getImage("tablesettings.gif"));
        this.getShell().setImage(UIPlugin.getDefault().getImage("settings_obj.gif"));
        this.getShell().setText(Messages.TableSettingsDialog_TABLE_SETTINGS_TITLE);
        this.updateEnabled();
        this.updateCheckBoxes();
        return contents;
    }

    int calculateHeight() {
        return this.getDialogArea().getSize().y;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentDialog = (Composite)super.createDialogArea(parent);
        parentDialog.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        Composite client = new Composite(parentDialog, 0);
        GridLayout layout = new GridLayout();
        GridData gd2 = new GridData(4, 4, true, true);
        Composite settingsContainer = this.createSettings(client);
        settingsContainer.setLayoutData((Object)gd2);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        return this.dialogArea;
    }

    public boolean close() {
        IFieldUI[] iFieldUIArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFieldUI m_field = iFieldUIArray[n2];
            if (m_field.isModifiable()) {
                m_field.setVisible(this.m_tableViewer.getChecked((Object)m_field));
            }
            ++n2;
        }
        this.save(this.m_lastField);
        return super.close();
    }

    private Composite createSettings(Composite parentDialog) {
        Composite settingsContainer = new Composite(parentDialog, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gd = null;
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.widthHint = 350;
        gd.horizontalSpan = 2;
        this.m_tableViewer = this.createTableViewer(settingsContainer);
        this.m_tableViewer.getTable().setLayoutData((Object)gd);
        this.createInputFields(settingsContainer);
        settingsContainer.setLayout((Layout)layout);
        return settingsContainer;
    }

    private void createInputFields(Composite parent) {
        GridData gd = new GridData(1, 4, false, false);
        Label label1 = new Label(parent, 0);
        label1.setText(Messages.TableSettingsDialog_MINIMUM_WIDTH);
        label1.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        this.m_minWidthText = new Text(parent, 2048);
        this.m_minWidthText.setLayoutData((Object)gd);
        gd = new GridData(1, 4, false, false);
        Label label2 = new Label(parent, 0);
        label2.setText(Messages.TableSettingsDialog_WEIGHT_FACTOR);
        label2.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        this.m_weightText = new Text(parent, 2048);
        this.m_weightText.setLayoutData((Object)gd);
        gd = new GridData(1, 4, true, false);
        gd.horizontalSpan = 2;
        if (this.showSortOrderSetting) {
            this.m_inintialSortOrder = new Button(parent, 32);
            this.m_inintialSortOrder.setText(Messages.TableSettingsDialog_INITIAL_SORT_ORDER_ASCENDING);
            this.m_inintialSortOrder.setLayoutData((Object)gd);
        }
    }

    private CheckboxTableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 67620);
        TableColumn tc1 = new TableColumn(table, 0);
        tc1.setText(Messages.TableSettingsDialog_VISIBLE);
        TableColumn tc2 = new TableColumn(table, 0);
        tc2.setText(Messages.TableSettingsDialog_MINIMUM_WIDTH_IN_PIXELS);
        TableColumn tc3 = new TableColumn(table, 0);
        tc3.setText(Messages.TableSettingsDialog_WEIGHT_FACTOR);
        if (this.showSortOrderSetting) {
            TableColumn tc4 = new TableColumn(table, 0);
            tc4.setText(Messages.TableSettingsDialog_INITIAL_SORT_ORDER);
        }
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(150, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, false));
        if (this.showSortOrderSetting) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(85, false));
        }
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        TableSettingsLabelProvider ibl = new TableSettingsLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)ibl);
        viewer.setContentProvider((IContentProvider)new TableSettingsContentProvider());
        viewer.setInput((Object)this.m_fields);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TableColumnSortManager tcsm = new TableColumnSortManager((TableViewer)viewer);
        tcsm.addColumn(tc1, 0, true);
        tcsm.addColumn(tc2, 1, true);
        tcsm.addColumn(tc3, 2, true);
        return viewer;
    }

    public void updateCheckBoxes() {
        IFieldUI[] iFieldUIArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFieldUI m_field = iFieldUIArray[n2];
            this.m_tableViewer.setChecked((Object)m_field, m_field.isVisible());
            ++n2;
        }
    }

    public void updateEnabled() {
        boolean enabled = !this.m_tableViewer.getSelection().isEmpty();
        this.m_minWidthText.setEnabled(enabled);
        this.m_weightText.setEnabled(enabled);
        if (this.showSortOrderSetting) {
            this.m_inintialSortOrder.setEnabled(enabled);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.save(this.m_lastField);
            IFieldUI newField = (IFieldUI)structuredSelection.getFirstElement();
            if (newField != null) {
                this.load(newField);
                this.m_lastField = newField;
            }
            this.updateEnabled();
        }
    }

    private void load(IFieldUI field) {
        if (field == null) {
            return;
        }
        this.m_minWidthText.setText(Integer.toString(field.getMinWidth()));
        this.m_weightText.setText(Integer.toString(field.getWidthWeight()));
        if (this.showSortOrderSetting) {
            this.m_inintialSortOrder.setSelection(field.getSortOrderAscending());
        }
    }

    private void save(IFieldUI field) {
        if (field == null) {
            return;
        }
        try {
            field.setMinWidth(Integer.parseInt(this.m_minWidthText.getText()));
            field.setWidthWeight(Integer.parseInt(this.m_weightText.getText()));
            if (this.showSortOrderSetting) {
                field.setSortOrder(this.m_inintialSortOrder.getSelection());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_tableViewer.refresh((Object)field, true);
    }

    void refreshTableItem() {
        this.m_tableViewer.refresh((Object)this.m_lastField, true);
        if (this.showSortOrderSetting) {
            this.m_tableViewer.setChecked((Object)this.m_lastField, this.m_inintialSortOrder.getSelection());
        }
    }

    public static class TableSettingsContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                Object[] f = (Object[])inputElement;
                ArrayList<IFieldUI> list = new ArrayList<IFieldUI>();
                Object[] objectArray = f;
                int n = f.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IFieldUI && ((IFieldUI)element).isModifiable()) {
                        list.add((IFieldUI)element);
                    }
                    ++n2;
                }
                return list.toArray(new IFieldUI[list.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TableSettingsLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IFieldUI) {
                IFieldUI field = (IFieldUI)element;
                if (columnIndex == 0) {
                    return field.getName();
                }
                if (columnIndex == 1) {
                    return Integer.toString(field.getMinWidth());
                }
                if (columnIndex == 2) {
                    return Integer.toString(field.getWidthWeight());
                }
                if (TableSettingsDialog.this.showSortOrderSetting && columnIndex == 3) {
                    return field.getSortOrderAscending() ? Messages.TableSettingsDialog_ASCENDING : Messages.TableSettingsDialog_DESCENDING;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

