/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Field;
import java.text.ParseException;

public abstract class MultiField
extends Field {
    private Field m_field;
    public static final String PROPERTY_SELECTED_FIELD = "selected_field";

    public MultiField(int id) {
        super(id);
    }

    public abstract Field[] getSupportedChildren();

    public abstract Field[] getChildren();

    public void selectField(Field field) {
        this.m_field = field;
        if (field != null) {
            this.setProperty(PROPERTY_SELECTED_FIELD, field.IDENTIFIER);
        }
        this.setChanged();
    }

    public Field getSelectedField() {
        if (this.m_field == null) {
            this.initializeDefaultSelection();
        }
        return this.m_field;
    }

    @Override
    public String formatObject(Object object) {
        Field field = this.getSelectedField();
        if (field != null) {
            return field.formatObject(object);
        }
        return super.formatObject(object);
    }

    @Override
    public String formatForClipboard(Object object) {
        Field field = this.getSelectedField();
        if (field != null) {
            return field.formatForClipboard(object);
        }
        return super.formatForClipboard(object);
    }

    @Override
    public String getUnit() {
        Field field = this.getSelectedField();
        if (field != null) {
            return field.getUnit();
        }
        return null;
    }

    public void initializeDefaultSelection() {
        Field[] children = this.getSupportedChildren();
        if (children.length > 0) {
            this.m_field = children[0];
        }
        String fieldID = this.getProperty(PROPERTY_SELECTED_FIELD);
        Field[] fieldArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Field element = fieldArray[n2];
            if (element.IDENTIFIER.equals(fieldID)) {
                this.m_field = element;
            }
            ++n2;
        }
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Field field = this.getSelectedField();
        if (field != null) {
            return field.parse(tokenizer);
        }
        return null;
    }

    @Override
    public int compare(Object a, Object b, boolean order) {
        Field field = this.getSelectedField();
        if (field != null) {
            field.compare(a, b, order);
        }
        return 0;
    }
}

