/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.ppc;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.ppc.PPCJavaCallWrapper;
import sun.jvm.hotspot.runtime.ppc.PPCRegisterMap;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class PPCFrame
extends Frame {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.ppc.PPCFrame.DEBUG") != null;
    private static final int BACK_LINK_OFFSET = 0;
    static final int RETURN_ADDR_OFFSET = 1;
    private static final int SENDER_SP_OFFSET = 0;
    private static final int R31_OFFSET_FROM_BACKLINK = -1;
    private static final int R29_OFFSET_FROM_BACKLINK = -3;
    private static final int R28_OFFSET_FROM_BACKLINK = -4;
    private static final int R27_OFFSET_FROM_BACKLINK = -5;
    private static final int R26_OFFSET_FROM_BACKLINK = -6;
    private static final int R25_OFFSET_FROM_BACKLINK = -7;
    private static final int R24_OFFSET_FROM_BACKLINK = -8;
    private static final int R3_OFFSET_FROM_BACKLINK = -29;
    private static final int LOW_CALLEE_SAVED_REGNUM = 19;
    private static final int INTERPRETER_FRAME_SAVED_SP_OFFSET = 0;
    private static final int INTERPRETER_FRAME_D_TEMP_OFFSET = 2;
    private static final int INTERPRETER_FRAME_L_TEMP_OFFSET = 4;
    private static final int INTERPRETER_FRAME_MIRROR_OFFSET = 6;
    private static int INTERPRETER_FRAME_LOCALS_OFFSET = -5;
    private static final int INTERPRETER_FRAME_BCX_OFFSET = -3;
    private static final int INTERPRETER_FRAME_METHOD_OFFSET = -4;
    private static final int INTERPRETER_FRAME_CACHE_OFFSET = -7;
    private static int INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET = -6;
    private static int INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET = -8;
    private static final int ENTRY_FRAME_CALL_WRAPPER_OFFSET = -29;
    private static final int NATIVE_FRAME_INITIAL_PARAM_OFFSET = 2;
    Address base_ptr;
    private Address raw_unextendedSP;

    private static synchronized void initialize(TypeDataBase db) {
    }

    private PPCFrame() {
    }

    private void adjustForDeopt() {
        NMethod nm;
        CodeBlob cb;
        if (this.pc != null && (cb = VM.getVM().getCodeCache().findBlob(this.pc)) != null && cb.isJavaMethod() && this.pc.equals((nm = (NMethod)cb).deoptHandlerBegin())) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.getUnextendedSP() != null, "null SP in Java frame");
            }
            this.pc = this.getUnextendedSP().getAddressAt(nm.origPCOffset());
            this.deoptimized = true;
        }
    }

    private PPCFrame(Address raw_sp, Address raw_fp, Address pc, long adjustment) {
        CodeBlob cb;
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = raw_sp.addOffsetTo(adjustment);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(raw_sp != null, "null SP in Java frame");
        }
        this.pc = pc;
        Address address = this.base_ptr = raw_sp != null ? raw_sp.getAddressAt(0L) : null;
        if (pc != null && (cb = VM.getVM().getCodeCache().findBlob(pc)) != null) {
            if (cb.isNMethod()) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(cb.getFrameSize() > 0L, "nmethod frames should not be empty");
                }
                this.base_ptr = raw_sp.addOffsetTo(adjustment).addOffsetTo(cb.getFrameSize());
            } else if (cb.getFrameSize() > 0L) {
                this.base_ptr = raw_sp.addOffsetTo(adjustment).addOffsetTo(cb.getFrameSize());
            }
        }
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("PPCFrame(sp, fp, pc): " + this);
            this.dumpStack();
        }
    }

    public PPCFrame(Address raw_sp, Address raw_fp, Address pc) {
        this(raw_sp, raw_fp, pc, 0L);
    }

    public PPCFrame(Address raw_sp, Address raw_fp) {
        this(raw_sp, raw_fp, raw_sp.getAddressAt(1L * VM.getVM().getAddressSize()), 0L);
    }

    public PPCFrame(Address raw_sp, Address raw_fp, long adjustment) {
        this(raw_sp, raw_fp, raw_sp.getAddressAt(1L * VM.getVM().getAddressSize()), adjustment);
    }

    @Override
    public Object clone() {
        PPCFrame frame = new PPCFrame();
        frame.raw_sp = this.raw_sp;
        frame.raw_unextendedSP = this.raw_unextendedSP;
        frame.base_ptr = this.base_ptr;
        frame.pc = this.pc;
        frame.deoptimized = this.deoptimized;
        return frame;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof PPCFrame)) {
            return false;
        }
        PPCFrame other = (PPCFrame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getUnextendedSP(), other.getUnextendedSP()) && AddressOps.equal(this.getFP(), other.getFP()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.raw_sp == null) {
            return 0;
        }
        return this.raw_sp.hashCode();
    }

    public String toString() {
        return "sp: " + (this.getSP() == null ? "null" : this.getSP().toString()) + ", unextendedSP: " + (this.getUnextendedSP() == null ? "null" : this.getUnextendedSP().toString()) + ", fp: " + (this.getFP() == null ? "null" : this.getFP().toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    @Override
    public Address getFP() {
        return this.base_ptr;
    }

    @Override
    public Address getSP() {
        return this.raw_sp;
    }

    @Override
    public Address getID() {
        return this.raw_sp;
    }

    @Override
    public boolean isSignalHandlerFrameDbg() {
        return false;
    }

    @Override
    public int getSignalNumberDbg() {
        return 0;
    }

    @Override
    public String getSignalNameDbg() {
        return null;
    }

    @Override
    public boolean isInterpretedFrameValid() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "Not an interpreted frame");
        }
        if (this.getFP() == null || this.getFP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getSP() == null || this.getSP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getFP().lessThanOrEqual(this.getSP())) {
            return false;
        }
        return this.getFP().minus(this.getSP()) <= 4096L * VM.getVM().getAddressSize();
    }

    @Override
    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        PPCRegisterMap map = (PPCRegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        map.setIncludeArgumentOops(false);
        if (this.isEntryFrame()) {
            return this.senderForEntryFrame(map);
        }
        if (this.isInterpretedFrame()) {
            return this.senderForInterpreterFrame(map);
        }
        if (!VM.getVM().isCore()) {
            if (cb == null) {
                cb = VM.getVM().getCodeCache().findBlob(this.getPC());
            } else if (Assert.ASSERTS_ENABLED) {
                Assert.that(cb.equals(VM.getVM().getCodeCache().findBlob(this.getPC())), "Must be the same");
            }
            if (cb != null) {
                return this.senderForCompiledFrame(map, cb);
            }
        }
        return new PPCFrame(this.getSenderSP(), this.getLink(), this.getSenderPC());
    }

    private Frame senderForEntryFrame(PPCRegisterMap map) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        PPCJavaCallWrapper jcw = (PPCJavaCallWrapper)this.getEntryFrameCallWrapper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!this.entryFrameIsFirst(), "next Java fp must be non zero");
            Assert.that(jcw.getLastJavaSP().greaterThan(this.getSP()), "must be above this frame on stack");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(jcw.getLastJavaPC() != null, "Cannot get last java pc");
        }
        PPCFrame fr = new PPCFrame(jcw.getLastJavaSP(), jcw.getLastJavaFP(), jcw.getLastJavaPC());
        map.clear();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map.getIncludeArgumentOops(), "should be set by clear");
        }
        return fr;
    }

    private Frame senderForInterpreterFrame(PPCRegisterMap map) {
        Address unextendedSP = this.addressOfStackSlot(-1).getAddressAt(0L);
        Address sender_sp = this.addressOfStackSlot(0);
        return new PPCFrame(sender_sp, this.getLink(), unextendedSP.minus(sender_sp));
    }

    private Frame senderForCompiledFrame(PPCRegisterMap map, CodeBlob cb) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        Address frame_top = this.base_ptr;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(cb.getFrameSize() >= 0L, "Compiled by Compiler1: do not use");
        }
        Address sender_pc = frame_top.getAddressAt(1L * VM.getVM().getAddressSize());
        long sp_adjustment = 0L;
        if (sender_pc != null) {
            Address caller_unextended_sp;
            CodeBlob sender_cb = VM.getVM().getCodeCache().findBlob(sender_pc);
            if (sender_cb != null) {
                NMethod nm = null;
                if (sender_cb.isNMethod()) {
                    nm = (NMethod)sender_cb;
                }
                if (nm != null && (nm.isDeoptMhEntry(sender_pc) || nm.isMethodHandleReturn(sender_pc))) {
                    caller_unextended_sp = !cb.isNMethod() ? this.addressOfStackSlot(-1).getAddressAt(0L) : this.getSP().getAddressAt(0L);
                    sp_adjustment = caller_unextended_sp.minus(this.base_ptr);
                }
            } else {
                caller_unextended_sp = this.getSP().getAddressAt(0L);
                sp_adjustment = caller_unextended_sp.minus(this.base_ptr);
            }
        }
        if (map.getUpdateMap() && cb.getOopMaps() != null) {
            OopMapSet.updateRegisterMap(this, cb, map, true);
        }
        map.setIncludeArgumentOops(cb.callerMustGCArguments());
        Address saved_fp = null;
        return new PPCFrame(frame_top, saved_fp, sp_adjustment);
    }

    @Override
    protected boolean hasSenderPD() {
        return true;
    }

    @Override
    public long frameSize() {
        return this.getSenderSP().minus(this.getSP()) / VM.getVM().getAddressSize();
    }

    @Override
    public Address getLink() {
        return this.addressOfStackSlot(0).getAddressAt(0L);
    }

    @Override
    public Address getUnextendedSP() {
        return this.raw_unextendedSP;
    }

    public Address getSenderPCAddr() {
        return this.addressOfStackSlot(0).getAddressAt(0L).addOffsetTo(1L * VM.getVM().getAddressSize());
    }

    @Override
    public Address getSenderPC() {
        return this.getSenderPCAddr().getAddressAt(0L);
    }

    public Address getNativeParamAddr(int idx) {
        return this.addressOfStackSlot(2 + idx);
    }

    @Override
    public Address getSenderSP() {
        return this.addressOfStackSlot(0);
    }

    @Override
    public Address addressOfInterpreterFrameLocals() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_LOCALS_OFFSET);
    }

    private Address addressOfInterpreterFrameBCX() {
        return this.addressOfStackSlot(-3);
    }

    @Override
    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        Address methodHandle = this.addressOfInterpreterFrameMethod().getAddressAt(0L);
        Method method = (Method)Metadata.instantiateWrapperFor(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    public Address addressOfInterpreterFrameMDX() {
        return null;
    }

    @Override
    public Address addressOfInterpreterFrameExpressionStack() {
        Address monitorEnd = this.interpreterFrameMonitorEnd().address();
        return monitorEnd.addOffsetTo(-1L * VM.getVM().getAddressSize());
    }

    @Override
    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    @Override
    public Address addressOfInterpreterFrameTOS() {
        return this.getSP();
    }

    @Override
    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    @Override
    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        return this.addressOfStackSlot(-1).getAddressAt(0L);
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorBegin() {
        return new BasicObjectLock(this.addressOfStackSlot(INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET).getAddressAt(0L));
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorEnd() {
        Address result = this.addressOfStackSlot(INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET).getAddressAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(AddressOps.gt(this.getFP(), result), "result must <  than frame pointer");
            Assert.that(AddressOps.lte(this.getSP(), result), "result must >= than stack pointer");
        }
        return new BasicObjectLock(result);
    }

    @Override
    public int interpreterFrameMonitorSize() {
        return BasicObjectLock.size();
    }

    @Override
    public Address addressOfInterpreterFrameMethod() {
        return this.addressOfStackSlot(-4);
    }

    @Override
    public Address addressOfInterpreterFrameCPCache() {
        return this.addressOfStackSlot(-7);
    }

    @Override
    public JavaCallWrapper getEntryFrameCallWrapper() {
        return new PPCJavaCallWrapper(this.addressOfStackSlot(-29).getAddressAt(0L));
    }

    @Override
    protected Address addressOfSavedOopResult() {
        return this.getSP().addOffsetTo((long)(VM.getVM().isClientCompiler() ? 2 : 3) * VM.getVM().getAddressSize());
    }

    @Override
    protected Address addressOfSavedReceiver() {
        return this.getSP().addOffsetTo(-4L * VM.getVM().getAddressSize());
    }

    private void dumpStack() {
        if (this.getFP() != null) {
            Address addr = this.getFP().addOffsetTo(1L * VM.getVM().getAddressSize());
            while (AddressOps.gte(addr, this.getSP())) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(-1L * VM.getVM().getAddressSize());
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                PPCFrame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

