/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

public final class WorldToDeviceConverter {
    private final int m_deviceMinimum;
    private final int m_deviceWidth;
    private final double m_worldMinimum;
    private final double m_worldWidth;

    public WorldToDeviceConverter(int deviceMinimum, int deviceMaximum, double worldMinimum, double worldMaximum) {
        this.m_deviceMinimum = deviceMinimum;
        this.m_worldMinimum = worldMinimum;
        this.m_worldWidth = worldMaximum - worldMinimum;
        this.m_deviceWidth = deviceMaximum - deviceMinimum;
    }

    public int getDeviceCoordinate(double worldCoordinate) {
        double normalizedCoordinate = (worldCoordinate - this.m_worldMinimum) / this.m_worldWidth;
        return (int)((double)this.m_deviceMinimum + normalizedCoordinate * (double)this.m_deviceWidth + 0.5);
    }

    public double getWorldCoordinate(int deviceCoordinate) {
        double normalizedCoordinate = (double)(deviceCoordinate - this.m_deviceMinimum) / (double)this.m_deviceWidth;
        return this.m_worldMinimum + normalizedCoordinate * this.m_worldWidth;
    }

    public int getDeviceWidth() {
        return this.m_deviceWidth;
    }

    public boolean canCalculateWorldCoordinate() {
        return this.m_deviceWidth != 0;
    }

    public boolean canCalculateDeviceCoordinate() {
        return this.m_worldWidth != 0.0;
    }
}

