/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Painter;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.NimbusEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public final class NimbusEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static Map<Integer, String[]> buttonIconPaths;

    public NimbusEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimbusEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Rectangle getTabRect(int n, Rectangle rectangle) {
        Rectangle rectangle2 = super.getTabRect(n, rectangle);
        rectangle2.y = 0;
        rectangle2.height = this.displayer.getHeight();
        return rectangle2;
    }

    @Override
    public void install() {
        super.install();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 12;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.displayer.getWidth();
        int n2 = this.displayer.getHeight();
        Painter painter = null;
        if (this.displayer.isActive()) {
            painter = (Painter)UIManager.get("TabbedPane:TabbedPaneTabArea[Enabled+MouseOver].backgroundPainter");
        }
        if (!this.displayer.isActive() || null == painter) {
            painter = (Painter)UIManager.get("TabbedPane:TabbedPaneTabArea[Enabled].backgroundPainter");
        }
        if (null != painter) {
            painter.paint(graphics2D, null, n, n2);
        }
        Color color = (Color)UIManager.get("nimbusBorder");
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 5, 0, n2);
        graphics.drawLine(n - 1, n2 - 5, n - 1, n2);
    }

    @Override
    protected void paintAfterTabs(Graphics graphics) {
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new NimbusEditorTabCellRenderer();
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/nimbus_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/nimbus_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/nimbus_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/nimbus_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/nimbus_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/nimbus_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/nimbus_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/nimbus_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/nimbus_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/nimbus_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/nimbus_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/nimbus_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/nimbus_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        NimbusEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    @Override
    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth() - 4, 2, component.getWidth(), component.getHeight());
    }

    @Override
    public Insets getTabAreaInsets() {
        Insets insets = super.getTabAreaInsets();
        insets.right += 4;
        return insets;
    }
}

