/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.HistoryState;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class History<T>
extends Observable {
    private final Object m_managedObject;
    private final List<HistoryState<T>> m_states = new ArrayList<HistoryState<T>>();
    private HistoryState<T> m_currentState = null;

    public History(Object managedObject) {
        this.m_managedObject = managedObject;
    }

    public synchronized boolean isRedoAvailable() {
        return this.isOffsetAvailable(1);
    }

    public synchronized boolean isUndoAvailable() {
        return this.isOffsetAvailable(-1);
    }

    public synchronized boolean undo() {
        if (this.isUndoAvailable()) {
            this.setState(this.getRelativeState(-1));
            return true;
        }
        return false;
    }

    public synchronized boolean redo() {
        if (this.isRedoAvailable()) {
            this.setState(this.getRelativeState(1));
            return true;
        }
        return false;
    }

    private synchronized HistoryState<T> getRelativeState(int delta) {
        return this.m_states.get(this.m_states.indexOf(this.m_currentState) + delta);
    }

    private synchronized boolean isOffsetAvailable(int offset) {
        int currentIndex = this.m_states.indexOf(this.m_currentState);
        if (currentIndex != -1) {
            return currentIndex + offset >= 0 && currentIndex + offset < this.m_states.size();
        }
        return false;
    }

    public synchronized void setState(HistoryState<T> state) {
        this.m_currentState = state;
        if (!this.m_states.contains(state)) {
            this.m_states.clear();
        }
        this.injectState(state);
        this.updateUndoRedoStatus();
    }

    private synchronized void updateUndoRedoStatus() {
        boolean redo = false;
        for (HistoryState<T> hs : this.m_states) {
            hs.setRedoState(redo);
            if (hs != this.m_currentState) continue;
            redo = true;
        }
    }

    private synchronized void injectState(HistoryState<T> candidate) {
        Setting destination = PersistenceToolkit.getSetting(this.m_managedObject);
        Setting source = candidate.getSetting();
        PersistenceToolkit.inject(destination, source);
        this.setChanged();
    }

    public synchronized void saveState() {
        this.saveState(null);
    }

    public synchronized void saveState(T object) {
        this.clearAfter(this.m_currentState);
        HistoryState<T> state = new HistoryState<T>(object, PersistenceToolkit.getSetting(this.m_managedObject));
        this.m_states.add(state);
        this.setState(state);
    }

    private synchronized void clearAfter(HistoryState<T> state) {
        ArrayList<HistoryState<T>> keepStates = new ArrayList<HistoryState<T>>();
        for (HistoryState<T> hs : this.m_states) {
            keepStates.add(hs);
            if (state != hs) continue;
            this.m_states.clear();
            this.m_states.addAll(keepStates);
            return;
        }
    }

    public synchronized List<HistoryState<T>> getStates() {
        return this.m_states;
    }

    public synchronized HistoryState<T> getCurrentState() {
        return this.m_currentState;
    }
}

