/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import org.netbeans.core.output2.FoldingSideBar;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.options.OutputOptions;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.util.Exceptions;

public abstract class AbstractOutputPane
extends JScrollPane
implements DocumentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ChangeListener,
MouseWheelListener,
Runnable {
    private boolean locked = true;
    private int fontHeight = -1;
    private int fontWidth = -1;
    protected JEditorPane textView = this.createTextView();
    private FoldingSideBar foldingSideBar;
    int lastCaretLine = 0;
    int caretBlinkRate = 500;
    boolean hadSelection = false;
    boolean recentlyReset = false;
    private boolean enqueued = false;
    private int lastLength = -1;
    private boolean inSendCaretToLine = false;
    private int lineToScroll = -1;
    private int lastPressedPos = -1;

    public AbstractOutputPane() {
        this.init();
    }

    public void doUpdateCaret() {
        Caret caret = this.textView.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(2);
        }
    }

    public void dontUpdateCaret() {
        Caret caret = this.textView.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
    }

    @Override
    public void requestFocus() {
        this.textView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textView.requestFocusInWindow();
    }

    public Font getViewFont() {
        return this.textView.getFont();
    }

    public void setViewFont(Font font) {
        this.textView.setFont(font);
        this.updateFont(this.getGraphics());
    }

    protected abstract JEditorPane createTextView();

    protected void documentChanged() {
        this.lastLength = -1;
        if (this.lineToScroll != -1) {
            if (this.scrollToLine(this.lineToScroll)) {
                this.lineToScroll = -1;
            }
        } else {
            this.ensureCaretPosition();
        }
        if (this.recentlyReset && this.isShowing()) {
            this.recentlyReset = false;
        }
        if (this.locked) {
            this.resetCursor();
        }
        if (this.isWrapped()) {
            this.getViewport().revalidate();
            this.getViewport().repaint();
        }
    }

    public abstract boolean isWrapped();

    public abstract void setWrapped(boolean var1);

    public boolean hasSelection() {
        return this.textView.getSelectionStart() != this.textView.getSelectionEnd();
    }

    public boolean isScrollLocked() {
        return this.locked;
    }

    public final void ensureCaretPosition() {
        if (!this.enqueued) {
            this.enqueued = true;
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.enqueued = false;
        if (this.locked) {
            this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getModel().getMaximum());
            this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getModel().getMinimum());
        }
        this.ensureCaretAtVisiblePosition();
    }

    private void ensureCaretAtVisiblePosition() {
        assert (EventQueue.isDispatchThread());
        Lines lines = this.getLines();
        if (lines != null) {
            int n;
            int n2 = n = lines.getLineAt(this.getCaretPos());
            while (n >= 0 && !lines.isVisible(n)) {
                n = lines.getParentFoldStart(n);
            }
            if (n != n2 && n >= 0) {
                this.getCaret().setDot(lines.getLineStart(n));
            }
        }
    }

    public int getSelectionStart() {
        return this.textView.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textView.getSelectionEnd();
    }

    public String getSelectedText() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        String string = null;
        if (n > 0 && n2 > n) {
            try {
                string = this.getDocument().getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string;
    }

    public void setSelection(int n, int n2) {
        int n3;
        int n4 = Math.min(n, n2);
        if (n4 == (n3 = Math.max(n, n2))) {
            this.getCaret().setDot(n4);
        } else {
            this.textView.setSelectionStart(n4);
            this.textView.setSelectionEnd(n3);
        }
    }

    public void selectAll() {
        this.unlockScroll();
        this.getCaret().setVisible(true);
        this.textView.setSelectionStart(0);
        this.textView.setSelectionEnd(this.getLength());
    }

    public boolean isAllSelected() {
        return this.textView.getSelectionStart() == 0 && this.textView.getSelectionEnd() == this.getLength();
    }

    protected void init() {
        this.foldingSideBar = new FoldingSideBar(this.textView, this);
        this.setRowHeaderView(this.foldingSideBar);
        this.setViewportView(this.textView);
        this.textView.setEditable(false);
        this.textView.addMouseListener(this);
        this.textView.addMouseMotionListener(this);
        this.textView.addKeyListener(this);
        this.textView.addMouseWheelListener(this);
        OCaret oCaret = new OCaret();
        oCaret.setUpdatePolicy(1);
        this.textView.setCaret(oCaret);
        this.getCaret().setSelectionVisible(true);
        this.getVerticalScrollBar().getModel().addChangeListener(this);
        this.getVerticalScrollBar().addMouseMotionListener(this);
        this.getViewport().addMouseListener(this);
        this.getVerticalScrollBar().addMouseListener(this);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(22);
        this.addMouseListener(this);
        this.getCaret().addChangeListener(this);
        this.textView.setFont(OutputOptions.getDefault().getFont(this.isWrapped()));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        Color color = UIManager.getColor("nb.output.selectionBackground");
        if (color != null) {
            this.textView.setSelectionColor(color);
        }
    }

    public final Document getDocument() {
        return this.textView.getDocument();
    }

    public final JTextComponent getTextView() {
        return this.textView;
    }

    public final FoldingSideBar getFoldingSideBar() {
        return this.foldingSideBar;
    }

    public final void copy() {
        if (this.getCaret().getDot() != this.getCaret().getMark()) {
            this.textView.copy();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public final void paste() {
        this.textView.paste();
    }

    protected void setDocument(Document document) {
        if (this.hasSelection()) {
            this.hasSelectionChanged(false);
        }
        this.hadSelection = false;
        this.lastCaretLine = 0;
        this.lastLength = -1;
        this.lineToScroll = -1;
        Document document2 = this.textView.getDocument();
        document2.removeDocumentListener(this);
        if (document != null) {
            this.textView.setDocument(document);
            document.addDocumentListener(this);
            this.lockScroll();
            this.recentlyReset = true;
        } else {
            this.textView.setDocument(new PlainDocument());
            this.textView.setEditorKit(new DefaultEditorKit());
        }
    }

    protected void setEditorKit(EditorKit editorKit) {
        Document document = this.textView.getDocument();
        this.textView.setEditorKit(editorKit);
        this.textView.setDocument(document);
        this.updateKeyBindings();
    }

    protected final void updateKeyBindings() {
        Keymap keymap = this.textView.getKeymap();
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(27, 0));
    }

    protected EditorKit getEditorKit() {
        return this.textView.getEditorKit();
    }

    public final int getLineCount() {
        return this.textView.getDocument().getDefaultRootElement().getElementCount();
    }

    public final int getLength() {
        if (this.lastLength == -1) {
            this.lastLength = this.textView.getDocument().getLength();
        }
        return this.lastLength;
    }

    public void scrollTo(int n) {
        this.getCaret().setDot(n);
        try {
            Rectangle rectangle = this.textView.modelToView(n);
            if (rectangle != null) {
                int n2 = (this.textView.getVisibleRect().height - rectangle.height) / 2;
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n2 + rectangle.height, rectangle.width, n2 * 2 + rectangle.height);
                this.textView.scrollRectToVisible(rectangle2);
            }
            this.locked = false;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendCaretToPos(int n, int n2, boolean bl) {
        this.inSendCaretToLine = true;
        try {
            this.getCaret().setVisible(true);
            this.getCaret().setSelectionVisible(true);
            if (bl) {
                this.scrollTo(n2);
                this.getCaret().setDot(n2);
                this.getCaret().moveDot(n);
                this.textView.repaint();
            } else {
                this.getCaret().setDot(n);
            }
        }
        catch (Error error) {
            if (error.getClass().getName().equals("javax.swing.text.StateInvariantError")) {
                Exceptions.attachMessage((Throwable)error, (String)("sendCaretToPos(" + n + ", " + n2 + ", " + bl + "), caret = " + this.getCaret() + ", highlighter = " + this.textView.getHighlighter() + ", document length = " + this.textView.getDocument().getLength()));
            }
            Exceptions.printStackTrace((Throwable)error);
        }
        finally {
            this.locked = false;
            this.inSendCaretToLine = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendCaretToLine(int n, boolean bl) {
        int n2 = this.getLineCount() - 1;
        if (n > n2) {
            n = n2;
        }
        this.inSendCaretToLine = true;
        try {
            this.getCaret().setVisible(true);
            this.getCaret().setSelectionVisible(true);
            Element element = this.textView.getDocument().getDefaultRootElement().getElement(n);
            int n3 = element.getStartOffset();
            if (bl) {
                this.getCaret().setDot(element.getEndOffset() - 1);
                this.getCaret().moveDot(n3);
                this.textView.repaint();
            } else {
                this.getCaret().setDot(n3);
            }
            if (!this.scrollToLine(n + 3) && this.isScrollLocked()) {
                this.lineToScroll = n + 3;
            }
        }
        catch (Error error) {
            if (error.getClass().getName().equals("javax.swing.text.StateInvariantError")) {
                Exceptions.attachMessage((Throwable)error, (String)("sendCaretToLine(" + n + ", " + bl + "), caret = " + this.getCaret() + ", highlighter = " + this.textView.getHighlighter() + ", document length = " + this.textView.getDocument().getLength()));
            }
            Exceptions.printStackTrace((Throwable)error);
        }
        finally {
            this.locked = false;
            this.inSendCaretToLine = false;
        }
        return true;
    }

    boolean scrollToLine(int n) {
        int n2 = Math.min(this.getLineCount() - 1, n);
        Rectangle rectangle = null;
        try {
            rectangle = this.textView.modelToView(this.textView.getDocument().getDefaultRootElement().getElement(n2).getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        if (rectangle == null) {
            return false;
        }
        boolean bl = this.locked;
        this.textView.scrollRectToVisible(rectangle);
        this.locked = bl;
        Rectangle rectangle2 = this.textView.getVisibleRect();
        return n == n2 && rectangle2.y + rectangle2.height == rectangle.y + rectangle.height;
    }

    boolean scrollToPos(int n) {
        Rectangle rectangle = null;
        try {
            rectangle = this.textView.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        if (rectangle == null) {
            return false;
        }
        boolean bl = this.locked;
        this.textView.scrollRectToVisible(rectangle);
        this.locked = bl;
        return true;
    }

    public final void lockScroll() {
        if (!this.locked) {
            this.locked = true;
        }
    }

    public final void unlockScroll() {
        if (this.locked) {
            this.locked = false;
        }
        this.lineToScroll = -1;
    }

    protected abstract void caretPosChanged(int var1);

    protected abstract void lineClicked(int var1, int var2);

    protected abstract void enterPressed();

    protected abstract void postPopupMenu(Point var1, Component var2);

    public final int getCaretLine() {
        int n = 0;
        int n2 = this.getCaret().getDot();
        if (n2 > 0) {
            n = this.textView.getDocument().getDefaultRootElement().getElementIndex(n2);
        }
        return n;
    }

    public final boolean isLineSelected(int n) {
        Element element = this.textView.getDocument().getDefaultRootElement().getElement(n);
        return element.getStartOffset() == this.getSelectionStart() && element.getEndOffset() - 1 == this.getSelectionEnd();
    }

    public final int getCaretPos() {
        return this.getCaret().getDot();
    }

    @Override
    public final void paint(Graphics graphics) {
        if (this.fontHeight == -1) {
            this.updateFont(graphics);
        }
        super.paint(graphics);
    }

    void updateFont(Graphics graphics) {
        if (graphics == null) {
            this.fontWidth = -1;
            this.fontHeight = -1;
            return;
        }
        this.fontHeight = graphics.getFontMetrics(this.textView.getFont()).getHeight();
        this.fontWidth = graphics.getFontMetrics(this.textView.getFont()).charWidth('m');
        this.getVerticalScrollBar().setUnitIncrement(this.fontHeight);
        this.getHorizontalScrollBar().setUnitIncrement(this.fontWidth);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getVerticalScrollBar().getModel()) {
            BoundedRangeModel boundedRangeModel;
            if (!this.locked && (boundedRangeModel = this.getVerticalScrollBar().getModel()).getValue() + boundedRangeModel.getExtent() == boundedRangeModel.getMaximum()) {
                this.lockScroll();
            }
        } else {
            boolean bl;
            if (!this.locked) {
                this.maybeSendCaretEnteredLine();
            }
            boolean bl2 = bl = this.textView.getSelectionStart() != this.textView.getSelectionEnd();
            if (bl != this.hadSelection) {
                this.hadSelection = bl;
                this.hasSelectionChanged(bl);
            }
        }
    }

    private void maybeSendCaretEnteredLine() {
        if (EventQueue.getCurrentEvent() instanceof MouseEvent) {
            return;
        }
        if (!this.locked && !this.inSendCaretToLine) {
            boolean bl;
            boolean bl2 = bl = this.textView.getSelectionStart() != this.textView.getSelectionEnd();
            if (!bl) {
                this.caretPosChanged(this.getCaretPos());
            }
            if (bl != this.hadSelection) {
                this.hadSelection = bl;
                this.hasSelectionChanged(bl);
            }
        }
    }

    private void hasSelectionChanged(boolean bl) {
        ((AbstractOutputTab)this.getParent()).hasSelectionChanged(bl);
    }

    @Override
    public final void changedUpdate(DocumentEvent documentEvent) {
        documentEvent.getLength();
        this.documentChanged();
        if (documentEvent.getOffset() + documentEvent.getLength() >= this.getCaretPos() && (this.locked || !(documentEvent instanceof OutputDocument.DO))) {
            OutputDocument outputDocument = (OutputDocument)documentEvent.getDocument();
            if (!(documentEvent instanceof OutputDocument.DO) && this.getCaretPos() >= outputDocument.getOutputLength()) {
                return;
            }
            this.getCaret().setDot(documentEvent.getOffset() + documentEvent.getLength());
        }
    }

    @Override
    public final void insertUpdate(DocumentEvent documentEvent) {
        documentEvent.getLength();
        this.documentChanged();
        if (documentEvent.getOffset() + documentEvent.getLength() >= this.getCaretPos() && (this.locked || !(documentEvent instanceof OutputDocument.DO))) {
            OutputDocument outputDocument = (OutputDocument)documentEvent.getDocument();
            if (!(documentEvent instanceof OutputDocument.DO) && this.getCaretPos() >= outputDocument.getOutputLength()) {
                return;
            }
            this.getCaret().setDot(documentEvent.getOffset() + documentEvent.getLength());
        }
    }

    @Override
    public final void removeUpdate(DocumentEvent documentEvent) {
        documentEvent.getLength();
        this.documentChanged();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isAltDown() || mouseEvent.isAltGraphDown() || mouseEvent.isControlDown() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            int n = this.getViewFont().getSize();
            int n2 = OutputOptions.getDefaultFont().getSize();
            this.changeFontSizeBy(n2 - n);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.resetCursor();
    }

    boolean isOnHyperlink(Point point) {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            int n = this.textView.viewToModel(point);
            if (n >= this.getLength()) {
                return false;
            }
            int n2 = this.getDocument().getDefaultRootElement().getElementIndex(n);
            int n3 = this.getDocument().getDefaultRootElement().getElement(n2).getStartOffset();
            int n4 = this.getDocument().getDefaultRootElement().getElement(n2).getEndOffset() - n3;
            try {
                boolean bl;
                Rectangle rectangle = this.textView.modelToView(n3 + n4 - 1);
                boolean bl2 = bl = point.x <= rectangle.x + rectangle.width || this.isWrapped() && point.y < rectangle.y;
                if (bl) {
                    return ((OutputDocument)document).getLines().getListener(n, null) != null;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private void resetCursor() {
        Cursor cursor = Cursor.getPredefinedCursor(2);
        if (this.textView.getCursor() != cursor) {
            this.textView.setCursor(cursor);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.textView) {
            if (this.isOnHyperlink(mouseEvent.getPoint())) {
                Cursor cursor = Cursor.getPredefinedCursor(12);
                if (this.textView.getCursor() != cursor) {
                    this.textView.setCursor(cursor);
                }
            } else {
                this.resetCursor();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getSource() == this.getVerticalScrollBar() && (n = mouseEvent.getY()) > this.getVerticalScrollBar().getHeight()) {
            this.lockScroll();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.getSource() == this.textView && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastPressedPos = this.textView.viewToModel(mouseEvent.getPoint());
        }
        if (this.locked && !mouseEvent.isPopupTrigger()) {
            object = this.getDocument().getDefaultRootElement().getElement(this.getLineCount() - 1);
            this.getCaret().setDot(object.getStartOffset());
            this.unlockScroll();
            if (mouseEvent.getSource() == this.textView) {
                this.getCaret().setDot(this.textView.viewToModel(mouseEvent.getPoint()));
            }
        }
        if (mouseEvent.isPopupTrigger()) {
            object = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.postPopupMenu((Point)object, this);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.textView && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n;
            int n2 = this.textView.viewToModel(mouseEvent.getPoint());
            if (n2 != -1 && n2 == this.lastPressedPos && (n = this.textView.getDocument().getDefaultRootElement().getElementIndex(n2)) >= 0) {
                this.lineClicked(n, n2);
                mouseEvent.consume();
            }
            this.lastPressedPos = -1;
        }
        if (mouseEvent.isPopupTrigger()) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.postPopupMenu(point, this);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 35: {
                if (!keyEvent.isControlDown()) break;
                this.lockScroll();
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.unlockScroll();
                break;
            }
            case 10: {
                this.enterPressed();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected abstract void changeFontSizeBy(int var1);

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.isAltDown() || mouseWheelEvent.isAltGraphDown() || mouseWheelEvent.isControlDown()) {
            int n = -mouseWheelEvent.getWheelRotation();
            this.changeFontSizeBy(n);
            mouseWheelEvent.consume();
            return;
        }
        if (mouseWheelEvent.isShiftDown()) {
            BoundedRangeModel boundedRangeModel = this.getHorizontalScrollBar().getModel();
            int n = boundedRangeModel.getValue();
            int n2 = Math.max(0, Math.min(boundedRangeModel.getMaximum(), n + mouseWheelEvent.getUnitsToScroll() * this.fontWidth));
            boundedRangeModel.setValue(n2);
            return;
        }
        BoundedRangeModel boundedRangeModel = this.getVerticalScrollBar().getModel();
        int n = boundedRangeModel.getMaximum();
        int n3 = boundedRangeModel.getExtent();
        int n4 = boundedRangeModel.getValue();
        if (mouseWheelEvent.getSource() == this.textView) {
            int n5 = Math.max(0, Math.min(boundedRangeModel.getMaximum(), n4 + mouseWheelEvent.getUnitsToScroll() * this.fontHeight));
            boundedRangeModel.setValue(n5);
            if (n5 + n3 >= n) {
                this.lockScroll();
                return;
            }
        }
        this.unlockScroll();
    }

    Caret getCaret() {
        return this.textView.getCaret();
    }

    public void collapseFold() {
        Lines lines = this.getLines();
        if (lines != null) {
            lines.hideFold(lines.getFoldStart(lines.visibleToRealLine(this.getCaretLine())));
        }
    }

    public void expandFold() {
        Lines lines = this.getLines();
        if (lines != null) {
            lines.showFold(lines.getFoldStart(lines.visibleToRealLine(this.getCaretLine())));
        }
    }

    public void collapseAllFolds() {
        Lines lines = this.getLines();
        if (lines != null) {
            lines.hideAllFolds();
        }
    }

    public void expandAllFolds() {
        Lines lines = this.getLines();
        if (lines != null) {
            lines.showAllFolds();
        }
    }

    public void collapseFoldTree() {
        Lines lines = this.getLines();
        if (lines != null) {
            lines.hideFoldTree(lines.getFoldStart(lines.visibleToRealLine(this.getCaretLine())));
        }
    }

    public void expandFoldTree() {
        Lines lines = this.getLines();
        if (lines != null) {
            lines.showFoldTree(lines.getFoldStart(lines.visibleToRealLine(this.getCaretLine())));
        }
    }

    private Lines getLines() {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            return ((OutputDocument)document).getLines();
        }
        return null;
    }

    private class OCaret
    extends DefaultCaret {
        private OCaret() {
        }

        @Override
        public void paint(Graphics graphics) {
            JEditorPane jEditorPane = AbstractOutputPane.this.textView;
            if (this.isVisible() && this.y >= 0) {
                try {
                    TextUI textUI = jEditorPane.getUI();
                    Rectangle rectangle = textUI.modelToView(jEditorPane, this.getDot(), Position.Bias.Forward);
                    if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
                        return;
                    }
                    if (this.width > 0 && this.height > 0 && !this._contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                        Rectangle rectangle2 = graphics.getClipBounds();
                        if (rectangle2 != null && !rectangle2.contains(this)) {
                            this.repaint();
                        }
                        this.damage(rectangle);
                    }
                    graphics.setColor(jEditorPane.getCaretColor());
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                    graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y + rectangle.height - 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private boolean _contains(int n, int n2, int n3, int n4) {
            int n5 = this.width;
            int n6 = this.height;
            if ((n5 | n6 | n3 | n4) < 0) {
                return false;
            }
            int n7 = this.x;
            int n8 = this.y;
            if (n < n7 || n2 < n8) {
                return false;
            }
            if (n3 > 0) {
                n5 += n7;
                if ((n3 += n) <= n) {
                    if (n5 >= n7 || n3 > n5) {
                        return false;
                    }
                } else if (n5 >= n7 && n3 > n5) {
                    return true;
                }
            } else if (n7 + n5 < n) {
                return false;
            }
            if (n4 > 0) {
                n6 += n8;
                if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
                    return false;
                }
            } else if (n8 + n6 < n2) {
                return false;
            }
            return true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AbstractOutputPane.this.getCaret().setBlinkRate(AbstractOutputPane.this.caretBlinkRate);
            AbstractOutputPane.this.getCaret().setVisible(true);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AbstractOutputPane.this.getCaret().setVisible(false);
        }

        @Override
        public void setSelectionVisible(boolean bl) {
            if (bl) {
                super.setSelectionVisible(bl);
            }
        }
    }
}

