/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.flightrecorder.ui.components.multichart.ChartImage;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public final class ImageRepository {
    private final HashMap<Object, ChartImage> m_imageLookup = new HashMap();
    private final Image m_progressImage;
    private final int m_width;
    private final int m_height;
    private final int m_maxImageCount;

    public ImageRepository(int width, int height, int maxItemCount) {
        this.m_width = Math.max(width, 1);
        this.m_height = Math.max(height, 1);
        this.m_maxImageCount = maxItemCount;
        this.m_progressImage = this.createProgressImage();
    }

    public void clear() {
        this.m_imageLookup.clear();
    }

    public Image getImage(Object object) {
        ChartImage image = this.m_imageLookup.get(object);
        if (image != null) {
            return image.getImage();
        }
        return null;
    }

    public Image createProgressImage() {
        BufferedImage progressImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        Graphics2D g = progressImage.createGraphics();
        int width = progressImage.getWidth();
        int height = progressImage.getHeight();
        int maxWidth = Math.max(width - 1, 0);
        int maxHeight = Math.max(height - 1, 0);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 10, maxWidth, maxHeight);
        g.setColor(Color.RED);
        g.drawString(Messages.IMAGE_REPOSITORY_PROGRESS_IMAGE_MESSAGE, 20, 40);
        return progressImage;
    }

    public void addImage(Object key, Image image) {
        if (this.m_imageLookup.size() > this.m_maxImageCount) {
            this.removeOldest();
        }
        this.m_imageLookup.put(key, new ChartImage(key, image));
    }

    private void removeOldest() {
        ChartImage oldestChartImage = null;
        for (ChartImage chartImage : this.m_imageLookup.values()) {
            if (oldestChartImage != null && chartImage.getLastImageAccess() >= oldestChartImage.getLastImageAccess()) continue;
            oldestChartImage = chartImage;
        }
        if (oldestChartImage != null) {
            this.m_imageLookup.remove(oldestChartImage.getKey());
        }
    }

    private int getWidth() {
        return this.m_width;
    }

    private int getHeight() {
        return this.m_height;
    }

    public Image getProgressImage() {
        return this.m_progressImage;
    }
}

