/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.flightrecorder.ui.components.multichart.ChartRow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import se.hirt.greychart.FontAndColors;

public final class MultiChartJComponent
extends JComponent {
    private static final long serialVersionUID = 3230073588451798727L;
    private int m_offset = 0;
    private List<ChartRow> m_rows = new ArrayList<ChartRow>();
    private int m_textWidth = 200;

    @Override
    public void paintComponent(Graphics g) {
        int y = this.m_offset;
        for (ChartRow c : this.m_rows) {
            Image im = c.getImage();
            String text = c.getText();
            int height = im.getHeight(null);
            g.setColor(FontAndColors.getDefaultBackground());
            g.fillRect(0, y, this.m_textWidth, y + height);
            if (text != null) {
                g.setColor(Color.black);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(text, g);
                int offset = (int)(((double)height - rect.getHeight()) / 2.0) + y;
                g.drawString(text, 5, offset);
            }
            g.drawImage(im, this.m_textWidth, y, null);
            g.setColor(new Color(236, 233, 213));
            g.drawLine(0, y + height - 1, im.getWidth(null) + this.m_textWidth, y + height - 1);
            g.drawLine(this.m_textWidth, y, this.m_textWidth, y + height - 1);
            y += height;
        }
    }

    public void setRows(List<ChartRow> rows) {
        this.m_rows = rows;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public void setTextWidth(int textWidth) {
        this.m_textWidth = textWidth;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }
}

