/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.selection;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeTreeContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.selection.TooltipProvider;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FieldFilter;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldTreeViewer;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.misc.ToolTipMouseTrackAdapter;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

abstract class BrowseWizard
extends WizardPage
implements IPerformFinishable {
    private final Field[] m_fields = new Field[]{EventTypeTreeContentProvider.FIELD_NAME, EventTypeTreeContentProvider.CONTENT_TYPE, EventTypeTreeContentProvider.ATTRIBUTE};
    private final EventTypeDescriptorRepository m_eventTypeRepository;
    private final FlightRecording m_recording;
    private final IServiceLocator m_locator;
    private final int m_style;
    private final boolean m_allowFullPath;
    private FieldTreeViewer m_viewer;
    private Label m_description;
    private IStructuredSelection m_selection;
    private boolean m_showAll;
    private Text m_selected;
    protected boolean m_fullPath;

    public BrowseWizard(IServiceLocator serviceLocator, EventTypeDescriptorRepository eventTypeRepository, boolean allowFullPath, int style) {
        super("browseWizard");
        this.m_allowFullPath = allowFullPath;
        this.m_locator = serviceLocator;
        this.m_recording = (FlightRecording)serviceLocator.getService(FlightRecording.class);
        this.m_eventTypeRepository = eventTypeRepository;
        this.m_style = style;
        this.m_showAll = eventTypeRepository == null;
    }

    protected Image getImage(Object element) {
        if (element instanceof IEventType) {
            return UIPlugin.getDefault().getImage("package_obj.gif");
        }
        if (element instanceof IField) {
            return UIPlugin.getDefault().getImage("property_obj.gif");
        }
        return null;
    }

    protected Font getFont(Object element) {
        if (this.acceptSelected(element)) {
            return UIPlugin.getDefault().getFontColorToolkit().getBoldTableFont();
        }
        return UIPlugin.getDefault().getFontColorToolkit().getItalicTableFont();
    }

    protected abstract boolean acceptSelected(Object var1);

    protected String getDescriptionText(Object selected) {
        if (selected instanceof IEventType) {
            return ((IEventType)selected).getDescription();
        }
        if (selected instanceof IField) {
            return ((IField)selected).getDescription();
        }
        return null;
    }

    protected Field[] getFields() {
        return this.m_fields;
    }

    public final IStructuredSelection getSelection() {
        return this.m_selection;
    }

    public boolean performFinish() {
        return true;
    }

    public final void createControl(Composite parent) {
        Composite client = new Composite(parent, 0);
        client.setLayout((Layout)new GridLayout(2, false));
        if (this.m_allowFullPath) {
            GridData gd0 = new GridData(4, 4, false, false);
            Button buttonFullPath = this.createFullPath(client);
            buttonFullPath.setLayoutData((Object)gd0);
            GridData gda = new GridData(4, 4, false, false);
            Button attribute = this.createAttribute(client);
            attribute.setLayoutData((Object)gda);
        }
        if (this.m_eventTypeRepository == null) {
            GridData gdFilter = new GridData(4, 4, true, false);
            gdFilter.horizontalSpan = 2;
            Text filterText = this.createFilter(client);
            filterText.setLayoutData((Object)gdFilter);
        }
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = 2;
        this.m_viewer = this.createViewer(client);
        this.m_viewer.getControl().setLayoutData((Object)gd1);
        if (this.m_eventTypeRepository != null) {
            GridData gdB = new GridData(4, 4, false, false);
            gdB.horizontalSpan = 2;
            Button button = this.createCheckBox(client);
            button.setLayoutData((Object)gdB);
        }
        Group group = new Group(client, 0);
        group.setText(Messages.EVENT_TYPES_WIZARD_DESCRIPTION_TEXT);
        GridData groupGd = new GridData(4, 4, true, false);
        groupGd.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout());
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.heightHint = 40;
        gd2.horizontalSpan = 2;
        this.m_description = new Label((Composite)group, 0);
        this.m_description.setLayoutData((Object)gd2);
        group.setLayoutData((Object)groupGd);
        GridData gdA = new GridData(4, 4, true, false);
        this.m_selected = new Text(client, 2050);
        gdA.heightHint = 40;
        gdA.horizontalSpan = 2;
        this.m_selected.setEditable(false);
        this.m_selected.setLayoutData((Object)gdA);
        this.updateInput();
        this.setSelectionDescription(null);
        this.getShell().setImage(UIPlugin.getDefault().getImage("property_obj.gif"));
        this.setControl((Control)client);
        this.setPageComplete(false);
    }

    private Button createAttribute(Composite client) {
        Button button = new Button(client, 16);
        button.setText(Messages.BROWSE_EVENT_TYPE_ATTRIBUTE_WIZARD_SELECT_FULL_ATTRIBUTE_PATH_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseWizard.this.m_fullPath = true;
                BrowseWizard.this.updateSelection();
            }
        });
        return button;
    }

    protected void updateSelection() {
        this.setSelectionText((IStructuredSelection)this.getViewer().getSelection());
    }

    private Button createFullPath(Composite client) {
        Button button = new Button(client, 16);
        button.setText(Messages.BROWSE_EVENT_TYPE_ATTRIBUTE_WIZARD_SELECT_ATTRIBUTE_ONLY_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseWizard.this.m_fullPath = false;
                BrowseWizard.this.updateSelection();
            }
        });
        return button;
    }

    private Text createFilter(Composite client) {
        final Text text = new Text(client, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowseWizard.this.updateFilter(text.getText());
            }
        });
        return text;
    }

    private void updateFilter(String filterString) {
        Filter f = new Filter();
        f.setFilterField(this.getFields()[0]);
        f.setFilterExpression(filterString);
        if (filterString.trim().length() != 0) {
            this.m_viewer.setFilters(new ViewerFilter[]{f});
        } else {
            this.m_viewer.setFilters(new ViewerFilter[0]);
        }
    }

    protected void setShowAll(boolean showAll) {
        this.m_showAll = showAll;
        this.updateInput();
    }

    private void updateInput() {
        if (this.m_showAll) {
            this.getViewer().setInput((Object)this.m_recording);
        } else {
            EventTypeAcceptor eta = new EventTypeAcceptor(this.m_locator, this.m_eventTypeRepository, true);
            this.getViewer().setInput((Object)eta);
        }
    }

    private Button createCheckBox(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText(Messages.EVENT_TYPES_WIZARD_SHOW_ALL_CHECKBOX_TEXT);
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseWizard.this.setShowAll(button.getSelection());
            }
        });
        return button;
    }

    protected final void setSelectionDescription(String description) {
        this.m_description.setText(description == null ? "" : description);
    }

    protected final Object getSelected() {
        if (!this.getViewer().getSelection().isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            return selection.getFirstElement();
        }
        return null;
    }

    protected final StructuredViewer getViewer() {
        return this.m_viewer;
    }

    private FieldTreeViewer createViewer(Composite client) {
        Field[] fields = this.getFields();
        FieldTreeViewer viewer = new FieldTreeViewer(new Tree(client, this.m_style | 0x800 | 0x10000), fields);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowseWizard.this.onSelectionChange((IStructuredSelection)event.getSelection());
            }
        });
        viewer.setContentProvider((IContentProvider)new EventTypeTreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(this.getFields(), (IBaseLabelProvider)new Provider(this)));
        viewer.getTree().addMouseTrackListener((MouseTrackListener)new ToolTipMouseTrackAdapter((Composite)viewer.getTree(), (IToolTipTextProvider)new TooltipProvider()));
        viewer.setFilters(new ViewerFilter[0]);
        viewer.setSorter(new ViewerSorter());
        return viewer;
    }

    private void onSelectionChange(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            this.setSelectionText(selection);
        }
        this.m_selection = this.acceptSelection(selection) ? selection : null;
        this.setPageComplete(this.m_selection != null);
    }

    private void setSelectionText(IStructuredSelection selection) {
        this.setSelectionDescription(selection.size() == 1 ? this.getDescriptionText(selection.getFirstElement()) : "");
        this.setSelectionText(this.formatDescription((ITreeSelection)selection));
    }

    private void setSelectionText(String text) {
        this.m_selected.setText(text);
    }

    private String formatDescription(ITreeSelection selection) {
        TreePath[] selectedObjects = selection.getPaths();
        StringBuilder text = new StringBuilder();
        int n = 0;
        while (n < selectedObjects.length) {
            TreePath path = selectedObjects[n];
            Object first = path.getFirstSegment();
            Object last = path.getLastSegment();
            if (last instanceof IField) {
                text.append(this.createPathFromSelection(first, last, true, this.m_fullPath));
            }
            if (last instanceof IEventType) {
                text.append(this.createPathFromSelection(first, last, false, true));
            }
            if (n != selectedObjects.length - 1) {
                text.append("; ");
            }
            ++n;
        }
        return text.toString();
    }

    public String getPath() {
        if (this.m_selection instanceof ITreeSelection && !this.m_selection.isEmpty()) {
            TreePath path = ((ITreeSelection)this.m_selection).getPaths()[0];
            Object first = path.getFirstSegment();
            Object last = path.getLastSegment();
            if (last instanceof IField) {
                return this.createPathFromSelection(first, last, true, this.m_fullPath);
            }
            if (last instanceof IEventType) {
                return this.createPathFromSelection(first, last, false, true);
            }
        }
        return null;
    }

    private String createPathFromSelection(Object firstSelected, Object lastSelected, boolean allowAttribute, boolean allowEventPath) {
        String path = "";
        if (allowEventPath && firstSelected instanceof IEventType) {
            path = String.valueOf(path) + ((IEventType)firstSelected).getPath();
        }
        if (allowAttribute && allowEventPath) {
            path = String.valueOf(path) + '#';
        }
        if (allowAttribute && lastSelected instanceof IField) {
            path = String.valueOf(path) + ((IField)lastSelected).getIdentifier();
        }
        return path;
    }

    protected boolean acceptSelection(IStructuredSelection selection) {
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            if (this.acceptSelected(it.next())) continue;
            return false;
        }
        return !selection.isEmpty();
    }

    private static class Filter
    extends FieldFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Row && ((Row)element).getElement() instanceof IEventType) {
                return super.select(viewer, parentElement, element);
            }
            return true;
        }
    }

    private static class Provider
    extends LabelProvider
    implements IFontProvider {
        private final BrowseWizard m_bw;

        Provider(BrowseWizard bw) {
            this.m_bw = bw;
        }

        public Image getImage(Object element) {
            return this.m_bw.getImage(element);
        }

        public Font getFont(Object element) {
            return this.m_bw.getFont(element);
        }
    }
}

