/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

class CLOBTypeCompiler
extends BaseTypeCompiler {
    CLOBTypeCompiler() {
    }

    @Override
    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isStringTypeId() || typeId.isBooleanTypeId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return typeId.isStringTypeId() || typeId.isBooleanTypeId();
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "java.sql.Clob";
            }
        }
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "getNullClob";
            }
        }
        return null;
    }

    @Override
    String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "getClobDataValue";
            }
        }
        return null;
    }

    @Override
    boolean pushCollationForDataValue(int n) {
        return n != 0;
    }
}

