/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealLastIndexKeyScanStatistics
extends RealNoPutResultSetStatistics {
    public String isolationLevel;
    public String tableName;
    public String indexName;
    public String lockString;

    public RealLastIndexKeyScanStatistics(int n, long l, long l2, long l3, long l4, int n2, String string, String string2, String string3, String string4, double d, double d2) {
        super(n, 1, 0, l, l2, l3, l4, n2, d, d2);
        this.tableName = string;
        this.indexName = string2;
        this.isolationLevel = string3;
        this.lockString = string4;
    }

    @Override
    public String getStatementExecutionPlanText(int n) {
        Object var3_2 = null;
        this.initFormatInfo(n);
        String string = this.indent + MessageService.getTextMessage("43X71.U", this.tableName, this.indexName);
        string = string + MessageService.getTextMessage("43X72.U", this.isolationLevel, this.lockString);
        string = string + "\n";
        return string + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.numOpens + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U", new Object[0]) + " = " + this.nextTime / (long)this.numOpens + "\n" : "") + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String string, int n) {
        if (string == null || string.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage(this.indexName == null ? "43X73.U" : "43X74.U", new Object[0]);
    }

    @Override
    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage("43X75.U", this.tableName);
        }
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        xPLAINVisitor.setNumberOfChildren(0);
        xPLAINVisitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        return "LASTINDEXKEYSCAN";
    }

    @Override
    public String getRSXplainDetails() {
        return "I: " + this.indexName + ", T: " + this.tableName;
    }

    @Override
    public Object getScanPropsDescriptor(Object object) {
        String string = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = new XPLAINScanPropsDescriptor((UUID)object, this.indexName, "I", null, string, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return xPLAINScanPropsDescriptor;
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = XPLAINUtil.getLockModeCode(this.lockString);
        String string2 = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, string, string2, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsSeen - this.rowsFiltered), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

