/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;

public class TimelineHeaderRenderer
extends BaseRenderer
implements TableCellRenderer {
    private final TableCellRenderer impl;
    private final int column;
    private final ViewManager view;
    private static LabelRenderer painter;
    private static int Y_LAF_OFFSET;

    public TimelineHeaderRenderer(TableCellRenderer tableCellRenderer, int n, ViewManager viewManager) {
        this.impl = tableCellRenderer;
        this.column = n;
        this.view = viewManager;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = this.column == jTable.convertColumnIndexToModel(n2);
        this.setVisible(bl3);
        Component component = this.impl.getTableCellRendererComponent(jTable, bl3 ? " " : object, bl, bl2, n, n2);
        if (bl3) {
            if (this.getParent() == null && component instanceof Container) {
                ((Container)component).add(this);
            }
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (painter == null) {
                TimelineHeaderRenderer.initStaticUI(component, jTableHeader);
            }
            TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n2);
            this.setSize(tableColumn.getWidth(), jTableHeader.getSize().height);
        }
        return component;
    }

    @Override
    public void paint(Graphics graphics) {
        long l = this.view.getFirstTimeMark(true);
        long l2 = this.view.getTimeMarksStep();
        String string = this.view.getTimeMarksFormat();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.view.getTimePosition(l, true);
        graphics.setColor(painter.getForeground());
        int n4 = n3;
        while (n3 < n) {
            this.paintTimeMark(n3, TimeAxisUtils.formatTime((Long)l, (String)string), n2, graphics);
            n3 = this.view.getTimePosition(l += l2, true);
            if (n3 <= n4) break;
            n4 = n3;
        }
    }

    private void paintTimeMark(int n, String string, int n2, Graphics graphics) {
        painter.setText(string);
        Dimension dimension = painter.getPreferredSize();
        painter.setSize(dimension);
        painter.move(n - dimension.width / 2, (n2 - dimension.height) / 2 + Y_LAF_OFFSET);
        painter.paint(graphics);
    }

    private static void initStaticUI(Component component, JTableHeader jTableHeader) {
        Font font;
        painter = new LabelRenderer(true);
        Color color = component.getForeground();
        if (color == null) {
            color = jTableHeader.getForeground();
        }
        if (color == null) {
            color = UIManager.getColor("TableHeader.foreground");
        }
        if (color != null) {
            painter.setForeground(color);
        }
        if ((font = component.getFont()) == null) {
            font = jTableHeader.getFont();
        }
        if (font == null) {
            font = UIManager.getFont("TableHeader.font");
        }
        if (font != null) {
            painter.setFont(font);
        }
        Y_LAF_OFFSET = UIUtils.isWindowsXPLookAndFeel() ? 1 : (UIUtils.isNimbusLookAndFeel() ? -1 : 0);
    }
}

