/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.animator;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Widget;

public final class PreferredLocationAnimator
extends Animator {
    private HashMap<Widget, Point> sourceLocations = new HashMap();
    private HashMap<Widget, Point> targetLocations = new HashMap();

    public PreferredLocationAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setPreferredLocation(Widget widget, Point point) {
        assert (widget != null);
        assert (point != null);
        if (!this.sourceLocations.isEmpty()) {
            this.sourceLocations.clear();
        }
        this.targetLocations.put(widget, point);
        this.start();
    }

    @Override
    protected void tick(double d) {
        for (Map.Entry<Widget, Point> entry : this.targetLocations.entrySet()) {
            Point point;
            Widget widget = entry.getKey();
            Point point2 = this.sourceLocations.get(widget);
            if (point2 == null) {
                point2 = widget.getPreferredLocation();
                if (point2 == null && (point2 = widget.getLocation()) == null) {
                    point2 = new Point();
                }
                this.sourceLocations.put(widget, point2);
            }
            if ((point = entry.getValue()) == null) continue;
            Point point3 = d >= 1.0 ? point : new Point((int)((double)point2.x + d * (double)(point.x - point2.x)), (int)((double)point2.y + d * (double)(point.y - point2.y)));
            widget.setPreferredLocation(point3);
        }
        if (d >= 1.0) {
            this.sourceLocations.clear();
            this.targetLocations.clear();
        }
    }
}

