/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class Producer
implements IProducer {
    private final Map<Integer, EventType> m_eventTypes = new HashMap<Integer, EventType>();
    private final Integer m_identifier;
    private final String m_uriString;
    private String m_description = "";
    private String m_name = "";
    private Color m_color = Color.GREEN;

    public Producer(int id, String name, String description, String uri) {
        this.m_identifier = id;
        this.m_name = name;
        this.m_description = description;
        this.m_uriString = uri;
        this.m_color = uri != null ? EventAppearance.getColor(uri) : Color.GREEN;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public int getId() {
        return this.m_identifier;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getURIString() {
        return this.m_uriString;
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    public Collection<EventType> getEventTypes() {
        return this.m_eventTypes.values();
    }

    public boolean hasEventType(int identifier) {
        return this.m_eventTypes.containsKey(identifier);
    }

    public EventType createEventType(int identifier) {
        Integer key = identifier;
        EventType eventType = this.m_eventTypes.get(key);
        if (eventType == null) {
            eventType = new EventType(this, identifier);
            this.m_eventTypes.put(identifier, eventType);
        }
        return eventType;
    }
}

