/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.AbstractLocalApplicationProperties;
import com.sun.deploy.cache.DefaultLocalApplicationProperties;
import com.sun.deploy.model.LocalApplicationProperties;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

class CompositeLocalApplicationProperties
extends AbstractLocalApplicationProperties {
    private static final String INSTALLED_KEY_PREFIX = "installed.";
    private static final Set<String> LOCAL_KEYS = new HashSet<String>(Arrays.asList("rebootNeeded", "nativeLibDir", "installDir", "launchCount", "askedInstall", "locallyInstalled", "extensionInstalled", "jnlpInstalled", "indirectPath", "mime.types.", "title", "extensions."));
    private LocalApplicationProperties localProperies;
    private LocalApplicationProperties roamingProperties;

    CompositeLocalApplicationProperties(URL uRL, String string, boolean bl) {
        this.localProperies = new DefaultLocalApplicationProperties(uRL, string, bl, LocalApplicationProperties.Kind.LOCAL);
        this.roamingProperties = new DefaultLocalApplicationProperties(uRL, string, bl, LocalApplicationProperties.Kind.ROAMING);
    }

    public URL getLocation() {
        return this.roamingProperties.getLocation();
    }

    public String getVersionId() {
        return this.roamingProperties.getVersionId();
    }

    public void setLastAccessed(Date date) {
        this.localProperies.setLastAccessed(date);
    }

    public Date getLastAccessed() {
        return this.localProperies.getLastAccessed();
    }

    public int getLaunchCount() {
        return this.localProperies.getLaunchCount();
    }

    public void incrementLaunchCount() {
        this.localProperies.incrementLaunchCount();
    }

    public void setAskedForInstall(boolean bl) {
        this.localProperies.setAskedForInstall(bl);
    }

    public boolean getAskedForInstall() {
        return this.localProperies.getAskedForInstall();
    }

    public void setRebootNeeded(boolean bl) {
        this.localProperies.setRebootNeeded(bl);
    }

    public boolean isRebootNeeded() {
        return this.localProperies.isRebootNeeded();
    }

    public void setShortcutInstalled(boolean bl) {
        this.localProperies.setShortcutInstalled(bl);
    }

    public boolean isShortcutInstalled() {
        return this.localProperies.isShortcutInstalled();
    }

    public boolean isShortcutInstalledSystem() {
        return this.localProperies.isShortcutInstalledSystem();
    }

    public void setExtensionInstalled(boolean bl) {
        this.localProperies.setExtensionInstalled(bl);
    }

    public boolean isExtensionInstalled() {
        return this.localProperies.isExtensionDescriptor();
    }

    public void setJnlpInstalled(boolean bl) {
        this.localProperies.setJnlpInstalled(bl);
    }

    public boolean isJnlpInstalled() {
        return this.localProperies.isJnlpInstalled();
    }

    public boolean forceUpdateCheck() {
        return this.roamingProperties.forceUpdateCheck();
    }

    public void setForceUpdateCheck(boolean bl) {
        this.roamingProperties.setForceUpdateCheck(bl);
    }

    public boolean isApplicationDescriptor() {
        return this.roamingProperties.isApplicationDescriptor();
    }

    public boolean isExtensionDescriptor() {
        return this.roamingProperties.isExtensionDescriptor();
    }

    public AssociationDesc[] getAssociations() {
        return this.localProperies.getAssociations();
    }

    public void addAssociation(AssociationDesc associationDesc) {
        this.localProperies.addAssociation(associationDesc);
    }

    public void setAssociations(AssociationDesc[] associationDescArray) {
        this.localProperies.setAssociations(associationDescArray);
    }

    public String getNativeLibDirectory() {
        return this.localProperies.getNativeLibDirectory();
    }

    public void setNativeLibDirectory(String string) {
        this.localProperies.setNativeLibDirectory(string);
    }

    public String getInstallDirectory() {
        return this.localProperies.getInstallDirectory();
    }

    public void setInstallDirectory(String string) {
        this.localProperies.setInstallDirectory(string);
    }

    public String getRegisteredTitle() {
        return this.localProperies.getRegisteredTitle();
    }

    public void setRegisteredTitle(String string) {
        this.localProperies.setRegisteredTitle(string);
    }

    public void put(String string, String string2) {
        if (LOCAL_KEYS.contains(string) || string.startsWith(INSTALLED_KEY_PREFIX)) {
            this.localProperies.put(string, string2);
        } else {
            this.roamingProperties.put(string, string2);
        }
    }

    public String get(String string) {
        if (LOCAL_KEYS.contains(string) || string.startsWith(INSTALLED_KEY_PREFIX)) {
            return this.localProperies.get(string);
        }
        return this.roamingProperties.get(string);
    }

    public void store() throws IOException {
        this.roamingProperties.store();
        this.localProperies.store();
    }

    public void refreshIfNecessary() {
        this.roamingProperties.refreshIfNecessary();
        this.localProperies.refreshIfNecessary();
    }

    public void refresh() {
        this.roamingProperties.refresh();
        this.localProperies.refresh();
    }

    public void setDraggedApplet() {
        this.roamingProperties.setDraggedApplet();
    }

    public boolean isDraggedApplet() {
        return this.roamingProperties.isDraggedApplet();
    }

    public String getDocumentBase() {
        return this.roamingProperties.getDocumentBase();
    }

    public void setDocumentBase(String string) {
        this.roamingProperties.setDocumentBase(string);
    }

    public String getCodebase() {
        return this.roamingProperties.getCodebase();
    }

    public void setCodebase(String string) {
        this.roamingProperties.setCodebase(string);
    }

    public String getMainPublisher() {
        return this.roamingProperties.getMainPublisher();
    }

    public String getMainTitle() {
        return this.roamingProperties.getMainTitle();
    }

    public void clearMainPublisherAndTitle() {
        this.roamingProperties.clearMainPublisherAndTitle();
    }

    public void storeMainPublisherAndTitle(String string, String string2) {
        this.roamingProperties.storeMainPublisherAndTitle(string, string2);
    }

    public void setOriginalURL(String string) {
        this.roamingProperties.setOriginalURL(string);
    }

    public String getOriginalURL() {
        return this.roamingProperties.getOriginalURL();
    }

    public void setEnableCustomPreloader(boolean bl) {
        this.roamingProperties.setEnableCustomPreloader(bl);
    }

    public boolean getEnableCustomPreloader() {
        return this.roamingProperties.getEnableCustomPreloader();
    }
}

