/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsValidator;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingOptionsToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.ValidationException;
import java.util.Map;

public final class ValidationToolkit {
    public static void validate(Map<String, ?> map) throws ValidationException {
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder localizedMessageBuilder = new StringBuilder();
        boolean caught = false;
        try {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                ValidationToolkit.validate(RecordingOptionsToolkit.getRecordingOptionConstraint(entry.getKey()), entry.getValue());
            }
        }
        catch (QuantityConversionException e) {
            caught = true;
            messageBuilder.append(e.getMessage());
            messageBuilder.append(System.getProperty("line.separator"));
            localizedMessageBuilder.append(e.getLocalizedMessage());
            localizedMessageBuilder.append(System.getProperty("line.separator"));
        }
        catch (IllegalArgumentException e) {
            caught = true;
            messageBuilder.append(e.getMessage());
            messageBuilder.append(System.getProperty("line.separator"));
            localizedMessageBuilder.append(e.getLocalizedMessage());
            localizedMessageBuilder.append(System.getProperty("line.separator"));
        }
        if (caught) {
            throw new ValidationException(messageBuilder.toString(), localizedMessageBuilder.toString());
        }
    }

    private static void validate(IOptionConstraint<?> optionConstraint, Object value) throws QuantityConversionException {
        RecordingOptionsValidator validator = new RecordingOptionsValidator(value, optionConstraint);
        validator.validate();
    }
}

