/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.model.fields.Row;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractFieldTreeContentProvider
implements ITreeContentProvider {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Row[] EMPTY_ROW_ARRAY = new Row[0];
    private int m_index = 0;

    protected abstract Object[] getRowChildren(Object var1);

    protected abstract Object[] getColumnObject(Object var1);

    protected abstract Object[] getRowElements(Object var1);

    protected abstract boolean hasRowChildren(Object var1);

    public Object getRowParent(Object element) {
        return null;
    }

    public final Object getParent(Object element) {
        if (element instanceof Row) {
            return this.getRowParent(((Row)element).ELEMENT);
        }
        return null;
    }

    public final Object[] getElements(Object inputElement) {
        return this.convertToRow(this.getRowElements(inputElement));
    }

    private final Row[] convertToRow(Object[] inputElement) {
        Row[] rows = EMPTY_ROW_ARRAY;
        try {
            if (inputElement != null) {
                rows = new Row[inputElement.length];
                this.m_index = 0;
                while (this.m_index < inputElement.length) {
                    rows[this.m_index] = new Row(inputElement[this.m_index], this.getColumnObject(inputElement[this.m_index]));
                    ++this.m_index;
                }
            }
        }
        catch (Exception exception) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Exception in ContentProvider Class" + this.getClass().getName(), exception);
        }
        return rows;
    }

    public final boolean hasChildren(Object element) {
        if (element instanceof Row) {
            return this.hasRowChildren(((Row)element).ELEMENT);
        }
        return this.getRowElements(element).length > 0;
    }

    public final Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Row) {
            return this.convertToRow(this.getRowChildren(((Row)parentElement).ELEMENT));
        }
        return this.convertToRow(this.getRowElements(parentElement));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

