/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class FieldBackgroundPainter
implements Listener {
    private final Field[] m_fields;
    private final double m_percentage;
    private final int m_margin;

    public FieldBackgroundPainter(Field[] fields, double percentage, int margin) {
        this.m_fields = fields;
        this.m_percentage = percentage;
        this.m_margin = margin;
    }

    public void handleEvent(Event event) {
        int visibleColumn = 0;
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            if (m_field.isVisible()) {
                if (visibleColumn == event.index) {
                    this.drawField(event, m_field);
                }
                ++visibleColumn;
            }
            ++n2;
        }
    }

    public void drawColumnPercentage(Event event, double percentage, MCColor mccolor) {
        GC gc = event.gc;
        Display display = event.display;
        Color color = null;
        try {
            color = mccolor.createSWTColor((Device)display);
            gc.setBackground(color);
            int width = (int)(this.m_percentage * percentage * (double)event.getBounds().width + 0.5) - this.m_margin;
            if (width > 0) {
                gc.fillRectangle(event.x, event.y, width, event.getBounds().height);
            }
        }
        finally {
            if (color != null) {
                color.dispose();
            }
        }
    }

    private void drawField(Event event, Field field) {
        Row row;
        Object element;
        Object data = event.item.getData();
        if (data instanceof Row && (element = (row = (Row)data).getElement()) != null) {
            Object columnValue = row.getColumn(field.INDEX);
            this.drawFieldBackground(event, element, columnValue, field);
        }
    }

    protected abstract void drawFieldBackground(Event var1, Object var2, Object var3, Field var4);
}

