/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.site;

import com.jrockit.mc.ui.fields.FieldPropertySource;
import com.jrockit.mc.ui.model.fields.IStructuredRowSelection;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.views.properties.IPropertySource;

public class SelectionProviderActivator {
    private final IWorkbenchPartSite m_masterSite;
    private ISelectionProvider m_provider;
    private TempAdapterFactory m_tempFactory = new TempAdapterFactory();
    private ProviderSelectionChangedListener m_listener;

    public SelectionProviderActivator(IWorkbenchPartSite site) {
        this.m_masterSite = site;
    }

    public void activate() {
        if (this.m_provider != null) {
            this.m_listener = new ProviderSelectionChangedListener();
            this.m_provider.addSelectionChangedListener((ISelectionChangedListener)this.m_listener);
            this.m_masterSite.setSelectionProvider(this.m_provider);
        }
    }

    public void deactivate() {
        if (this.m_listener != null) {
            if (this.m_provider != null) {
                this.m_provider.removeSelectionChangedListener((ISelectionChangedListener)this.m_listener);
            }
            this.m_masterSite.setSelectionProvider(null);
            Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.m_tempFactory);
            this.m_listener = null;
        }
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.deactivate();
        this.m_provider = provider;
    }

    class ProviderSelectionChangedListener
    implements ISelectionChangedListener {
        ProviderSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredRowSelection rs;
            Object object;
            if (event.getSelection() instanceof IStructuredRowSelection && (object = (rs = (IStructuredRowSelection)event.getSelection()).getFirstElement()) != null) {
                Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)SelectionProviderActivator.this.m_tempFactory);
                FieldPropertySource fps = new FieldPropertySource(rs.getFields(), rs.getFirstRowElement());
                SelectionProviderActivator.this.m_tempFactory = new TempAdapterFactory();
                SelectionProviderActivator.this.m_tempFactory.add(rs.getFirstElement(), fps, IPropertySource.class);
                Platform.getAdapterManager().registerAdapters((IAdapterFactory)SelectionProviderActivator.this.m_tempFactory, object.getClass());
            }
        }
    }

    public static class TempAdapterFactory
    implements IAdapterFactory {
        private Class<?> m_adapterType;
        private Object m_adaptableObject;
        private Object m_adaption;

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adapterType.equals(this.m_adapterType) && adaptableObject == this.m_adaptableObject) {
                return this.m_adaption;
            }
            return null;
        }

        public Class[] getAdapterList() {
            Class[] classArray;
            if (this.m_adapterType == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = this.m_adapterType;
            }
            return classArray;
        }

        public void add(Object adaptableObject, Object adaption, Class<?> adapterType) {
            this.m_adaptableObject = adaptableObject;
            this.m_adaption = adaption;
            this.m_adapterType = adapterType;
        }
    }
}

