/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.wizards;

import com.jrockit.mc.ui.checkedstate.CheckedStateManager;
import com.jrockit.mc.ui.checkedstate.ContainerProviderModifier;
import com.jrockit.mc.ui.checkedstate.SetProviderModifier;
import com.jrockit.mc.ui.wizards.ExportToFileWizardPage;
import com.jrockit.mc.ui.wizards.Messages;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class ExportTreeToFileWizardPage
extends ExportToFileWizardPage {
    private CheckedStateManager m_checkManager;
    public static final String TREE_NAME = "wizards.importexport.tree.name";

    public ExportTreeToFileWizardPage(String pageName, String fileExtension) {
        super(pageName, fileExtension);
    }

    protected abstract void initializeViewer(TreeViewer var1);

    private Composite createButtonContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.createButtonWithHandler(container, Messages.TreeContentProviderWizardPage_SELECT_ALL_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTreeToFileWizardPage.this.m_checkManager.selectAll();
                ExportTreeToFileWizardPage.this.updatePageComplete();
            }
        });
        this.createButtonWithHandler(container, Messages.TreeContentProviderWizardPage_DESELECT_ALL_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTreeToFileWizardPage.this.m_checkManager.deselectAll();
                ExportTreeToFileWizardPage.this.updatePageComplete();
            }
        });
        return container;
    }

    private Control createButtonWithHandler(Composite parent, String text, SelectionListener s) {
        GridData gd1 = new GridData(4, 4, true, false);
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener(s);
        button.setLayoutData((Object)gd1);
        return button;
    }

    @Override
    protected Composite createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        CheckboxTreeViewer ctw = new CheckboxTreeViewer(container);
        ctw.getTree().setData("name", (Object)TREE_NAME);
        this.initializeViewer((TreeViewer)ctw);
        this.m_checkManager = new CheckedStateManager(ctw);
        ContainerProviderModifier spm = new ContainerProviderModifier(this.m_checkManager);
        SetProviderModifier setProviderModifier = new SetProviderModifier();
        this.m_checkManager.addModifierProvider(spm);
        this.m_checkManager.addModifierProvider(setProviderModifier);
        this.setPageComplete(false);
        ctw.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportTreeToFileWizardPage.this.updatePageComplete();
            }
        });
        Composite buttonBar = this.createButtonContainer(container);
        container.setLayout((Layout)new GridLayout(2, false));
        ctw.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        buttonBar.setLayoutData((Object)new GridData(4, 4, false, true));
        return container;
    }

    @Override
    protected boolean isSelectionValid() {
        Collection<?> selected = this.getSelectedItems();
        return selected != null && selected.size() > 0;
    }

    public Collection<?> getSelectedItems() {
        return this.m_checkManager.getAllChecked();
    }
}

