/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.BranchInstruction;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCJmplInstruction
extends SPARCInstruction
implements BranchInstruction {
    protected final SPARCRegisterIndirectAddress addr;
    protected final SPARCRegister rd;

    protected SPARCJmplInstruction(String name, SPARCRegisterIndirectAddress addr, SPARCRegister rd) {
        super(name);
        this.addr = addr;
        this.rd = rd;
    }

    public SPARCJmplInstruction(SPARCRegisterIndirectAddress addr, SPARCRegister rd) {
        this("jmpl", addr, rd);
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        String addrStr = this.addr.toString();
        addrStr = addrStr.substring(1, addrStr.length() - 1);
        if (this.rd == SPARCRegisters.G0) {
            buf.append("jmp");
            buf.append(spaces);
            buf.append(addrStr);
        } else {
            buf.append(this.getName());
            buf.append(spaces);
            buf.append(addrStr);
            buf.append(comma);
            buf.append(this.rd.toString());
        }
        return buf.toString();
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.getDescription();
    }

    public Address getBranchDestination() {
        return this.addr;
    }

    public SPARCRegister getReturnAddressRegister() {
        return this.rd;
    }

    public boolean isAnnuledBranch() {
        return false;
    }

    public boolean isBranch() {
        return true;
    }

    public boolean isConditional() {
        return false;
    }
}

