/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9BranchDecoder;

abstract class V9RegisterBranchDecoder
extends V9BranchDecoder {
    V9RegisterBranchDecoder() {
    }

    static int getDisp16(int instruction) {
        int offset = 0x3FFF & instruction | (0x300000 & instruction) >>> 6;
        offset = V9RegisterBranchDecoder.extractSignedIntFromNBits(offset, 16);
        return offset <<= 2;
    }

    String getConditionName(int conditionCode, boolean isAnnuled) {
        return null;
    }

    abstract String getRegisterConditionName(int var1);

    public Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        int rcond = (0xE000000 & instruction) >>> 25;
        if (rcond == 0 || rcond == 4) {
            return factory.newIllegalInstruction(instruction);
        }
        SPARCRegister rs1 = SPARCRegisters.getRegister(V9RegisterBranchDecoder.getSourceRegister1(instruction));
        boolean predictTaken = V9RegisterBranchDecoder.getPredictTaken(instruction);
        boolean annuled = V9RegisterBranchDecoder.getAnnuledBit(instruction);
        PCRelativeAddress addr = new PCRelativeAddress(V9RegisterBranchDecoder.getDisp16(instruction));
        String name = this.getRegisterConditionName(rcond);
        return v9factory.newV9RegisterBranchInstruction(name, addr, annuled, rcond, rs1, predictTaken);
    }
}

