/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.RawHeapVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.HistoryComboBox;
import sun.jvm.hotspot.ui.ProgressBarPanel;
import sun.jvm.hotspot.utilities.AddressOps;

public class FindInHeapPanel
extends JPanel {
    private RawHeapVisitor iterator;
    private long addressSize;
    private long usedSize;
    private long iterated;
    private Address value;
    private ProgressBarPanel progressBar;
    private HistoryComboBox addressField;
    private JButton findButton;
    private JTextArea textArea;
    private ArrayList updates;
    private double lastFrac;
    static final double minUpdateFraction = 0.05;
    private boolean pendingUpdate = false;

    public FindInHeapPanel() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel("Address to search for:"));
        this.addressField = new HistoryComboBox();
        panel.add(this.addressField);
        this.addressSize = VM.getVM().getAddressSize();
        this.iterator = new RawHeapVisitor(){
            boolean error = false;

            public void prologue(long used) {
                FindInHeapPanel.this.usedSize = used;
                FindInHeapPanel.this.iterated = 0L;
                FindInHeapPanel.this.lastFrac = 0.0;
                this.error = false;
                FindInHeapPanel.this.updates = new ArrayList();
            }

            public void visitAddress(Address addr) {
                if (this.error) {
                    return;
                }
                Address val = addr.getAddressAt(0L);
                if (AddressOps.equal(val, FindInHeapPanel.this.value)) {
                    this.error = FindInHeapPanel.this.reportResult(addr);
                }
                FindInHeapPanel.this.iterated += FindInHeapPanel.this.addressSize;
                FindInHeapPanel.this.updateProgressBar();
            }

            public void visitCompOopAddress(Address addr) {
                if (this.error) {
                    return;
                }
                Address val = addr.getCompOopAddressAt(0L);
                if (AddressOps.equal(val, FindInHeapPanel.this.value)) {
                    this.error = FindInHeapPanel.this.reportResult(addr);
                }
                FindInHeapPanel.this.iterated += FindInHeapPanel.this.addressSize;
                FindInHeapPanel.this.updateProgressBar();
            }

            public void epilogue() {
                FindInHeapPanel.this.iterated = 0L;
                FindInHeapPanel.this.updateProgressBar();
                FindInHeapPanel.this.findButton.setEnabled(true);
            }
        };
        this.findButton = new JButton("Find");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindInHeapPanel.this.clearResultWindow();
                try {
                    Address val = VM.getVM().getDebugger().parseAddress(FindInHeapPanel.this.addressField.getText());
                    FindInHeapPanel.this.value = val;
                    FindInHeapPanel.this.findButton.setEnabled(false);
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                VM.getVM().getObjectHeap().iterateRaw(FindInHeapPanel.this.iterator);
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        FindInHeapPanel.this.findButton.setEnabled(true);
                                    }
                                });
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                    t.start();
                }
                catch (Exception ex) {
                    FindInHeapPanel.this.textArea.setText("Error parsing address");
                }
            }
        };
        panel.add(this.findButton);
        this.findButton.addActionListener(listener);
        this.addressField.addActionListener(listener);
        topPanel.add(panel);
        this.progressBar = new ProgressBarPanel(1, "Search progress:");
        topPanel.add(this.progressBar);
        this.add((Component)topPanel, "North");
        this.textArea = new JTextArea();
        JScrollPane scroller = new JScrollPane(this.textArea);
        this.add((Component)scroller, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportResult(Address addr) {
        FindInHeapPanel findInHeapPanel = this;
        synchronized (findInHeapPanel) {
            try {
                this.updates.add("found at " + addr + "\n");
                if (!this.pendingUpdate) {
                    this.pendingUpdate = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FindInHeapPanel.this.updateResultWindow();
                        }
                    });
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return true;
            }
        }
        return false;
    }

    private void clearResultWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Document d = FindInHeapPanel.this.textArea.getDocument();
                try {
                    d.remove(0, d.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private synchronized void updateResultWindow() {
        if (this.updates.size() > 0) {
            Iterator i = this.updates.iterator();
            while (i.hasNext()) {
                this.textArea.append((String)i.next());
            }
            this.updates = new ArrayList();
        }
        this.pendingUpdate = false;
    }

    private void invokeInDispatchThread(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void updateProgressBar() {
        final double frac = (double)this.iterated / (double)this.usedSize;
        if (frac == 0.0 || frac - this.lastFrac > 0.05) {
            this.lastFrac = frac;
            if (this.iterated > this.usedSize) {
                System.out.println("iterated " + this.iterated + " usedSize " + this.usedSize);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindInHeapPanel.this.progressBar.setValue(frac);
                }
            });
        }
    }
}

