/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.tree;

import java.util.List;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.IndexableFieldIdentifier;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.RootTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;
import sun.jvm.hotspot.utilities.LivenessPathElement;

public class RevPtrsTreeNodeAdapter
extends FieldTreeNodeAdapter {
    private static FieldIdentifier fid = new NamedFieldIdentifier("_revPtrs");
    private List children;

    public RevPtrsTreeNodeAdapter(Oop oop) {
        this(oop, false);
    }

    public RevPtrsTreeNodeAdapter(Oop oop, boolean treeTableMode) {
        super(fid, treeTableMode);
        this.children = VM.getVM().getRevPtrs().get(oop);
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public SimpleTreeNode getChild(int index) {
        LivenessPathElement lpe = (LivenessPathElement)this.children.get(index);
        IndexableFieldIdentifier ifid = new IndexableFieldIdentifier(index);
        Oop oop = lpe.getObj();
        if (oop != null) {
            return new OopTreeNodeAdapter(oop, ifid, this.getTreeTableMode());
        }
        NamedFieldIdentifier nfi = (NamedFieldIdentifier)lpe.getField();
        return new RootTreeNodeAdapter(nfi.getName(), ifid, this.getTreeTableMode());
    }

    public boolean isLeaf() {
        return false;
    }

    public int getIndexOfChild(SimpleTreeNode child) {
        FieldIdentifier id = ((FieldTreeNodeAdapter)child).getID();
        IndexableFieldIdentifier ifid = (IndexableFieldIdentifier)id;
        return ifid.getIndex();
    }

    public String getName() {
        return "<<Reverse pointers>>";
    }

    public String getValue() {
        return "";
    }
}

