/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class RobustOopDeterminator {
    private static OopField klassField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("oopDesc");
        klassField = VM.getVM().isCompressedOopsEnabled() ? type.getNarrowOopField("_metadata._compressed_klass") : type.getOopField("_metadata._klass");
    }

    public static boolean oopLooksValid(OopHandle oop) {
        if (oop == null) {
            return false;
        }
        if (!VM.getVM().getUniverse().isIn(oop)) {
            return false;
        }
        try {
            for (int i = 0; i < 4; ++i) {
                OopHandle next = klassField.getValue(oop);
                if (next == null) {
                    return false;
                }
                if (next.equals(oop)) {
                    return true;
                }
                oop = next;
            }
            return false;
        }
        catch (AddressException e) {
            return false;
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                RobustOopDeterminator.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

