/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.utilities.soql.JSJavaArrayKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaClass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;

public abstract class JSJavaArray
extends JSJavaObject {
    private JSJavaArrayKlass type;

    public JSJavaArray(Array array, JSJavaFactory fac) {
        super(array, fac);
        this.type = (JSJavaArrayKlass)fac.newJSJavaKlass(array.getKlass());
    }

    public final Array getArray() {
        return (Array)this.getOop();
    }

    public final JSJavaClass getJSJavaClass() {
        return this.type.getJSJavaClass();
    }

    public Object get(String name) {
        if (name.equals("length")) {
            return new Integer((int)this.getArray().getLength());
        }
        return super.get(name);
    }

    public Object get(int index) {
        return this.isInRange(index) ? this.type.getFieldValue(index, this.getArray()) : super.get(index);
    }

    public Object[] getIds() {
        Object[] superFields = super.getIds();
        int len = (int)this.getArray().getLength();
        Object[] res = new Object[superFields.length + len];
        for (int i = 0; i < len; ++i) {
            res[i] = new Integer(i);
        }
        System.arraycopy(superFields, 0, res, len, superFields.length);
        return res;
    }

    public boolean has(String name) {
        if (name.equals("length")) {
            return true;
        }
        return super.has(name);
    }

    public boolean has(int index) {
        if (this.isInRange(index)) {
            return true;
        }
        return super.has(index);
    }

    public void put(String name, Object value) {
        if (!name.equals("length")) {
            super.put(name, value);
        }
    }

    public void put(int index, Object value) {
        if (!this.isInRange(index)) {
            super.put(index, value);
        }
    }

    private boolean isInRange(int index) {
        return index >= 0 && (long)index < this.getArray().getLength();
    }
}

