/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.SplitSubModel;

final class EditorSplitSubModel
extends SplitSubModel {
    private final EditorNode editorNode;

    public EditorSplitSubModel(Model model, SplitSubModel splitSubModel) {
        super(model);
        this.editorNode = new EditorNode(splitSubModel);
        this.addNodeToTree(this.editorNode, new SplitConstraint[0]);
    }

    @Override
    protected boolean removeNodeFromTree(SplitSubModel.Node node) {
        if (node == this.editorNode) {
            return false;
        }
        return super.removeNodeFromTree(node);
    }

    public boolean setEditorNodeConstraints(SplitConstraint[] splitConstraintArray) {
        super.removeNodeFromTree(this.editorNode);
        return this.addNodeToTree(this.editorNode, splitConstraintArray);
    }

    public SplitConstraint[] getEditorNodeConstraints() {
        return this.editorNode.getNodeConstraints();
    }

    public SplitSubModel getEditorArea() {
        return this.editorNode.getEditorArea();
    }

    @Override
    public boolean setSplitWeights(ModelElement[] modelElementArray, double[] dArray) {
        if (super.setSplitWeights(modelElementArray, dArray)) {
            return true;
        }
        return this.getEditorArea().setSplitWeights(modelElementArray, dArray);
    }

    @Override
    protected boolean addNodeToTreeAroundEditor(SplitSubModel.Node node, String string) {
        EditorNode editorNode = this.editorNode;
        if (editorNode == this.root) {
            int n = string == "top" || string == "left" ? 0 : -1;
            int n2 = n == 0 ? -1 : 0;
            int n3 = string == "top" || string == "bottom" ? 0 : 1;
            SplitSubModel.SplitNode splitNode = new SplitSubModel.SplitNode(n3);
            splitNode.setChildAt(n, 0.25, node);
            splitNode.setChildAt(n2, 0.75, editorNode);
            this.root = splitNode;
        } else {
            SplitSubModel.SplitNode splitNode = editorNode.getParent();
            if (splitNode == null) {
                return false;
            }
            int n = splitNode.getChildIndex(editorNode);
            double d = splitNode.getChildSplitWeight(editorNode);
            int n4 = string == "top" || string == "bottom" ? 0 : 1;
            SplitSubModel.SplitNode splitNode2 = new SplitSubModel.SplitNode(n4);
            splitNode.removeChild(editorNode);
            int n5 = string == "top" || string == "left" ? 0 : -1;
            int n6 = n5 == 0 ? -1 : 0;
            splitNode2.setChildAt(n5, 0.25, node);
            splitNode2.setChildAt(n6, 0.75, editorNode);
            splitNode.setChildAt(n, d, splitNode2);
        }
        return true;
    }

    static class EditorNode
    extends SplitSubModel.Node {
        private final SplitSubModel editorArea;

        public EditorNode(SplitSubModel splitSubModel) {
            this.editorArea = splitSubModel;
        }

        @Override
        public boolean isVisibleInSplit() {
            return true;
        }

        public SplitSubModel getEditorArea() {
            return this.editorArea;
        }

        @Override
        public double getResizeWeight() {
            return 1.0;
        }

        @Override
        public ModeStructureSnapshot.ElementSnapshot createSnapshot() {
            return new ModeStructureSnapshot.EditorSnapshot(this, null, this.editorArea.createSplitSnapshot(), this.getResizeWeight());
        }
    }
}

