/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.windows.TopComponent;

final class TopComponentSubModel {
    private final List<TopComponent> openedTopComponents = new ArrayList<TopComponent>(10);
    private final List<String> tcIDs = new ArrayList<String>(10);
    private final int kind;
    private String selectedTopComponentID;
    private String previousSelectedTopComponentID;
    private static final String IS_SLIDING = "isSliding";

    public TopComponentSubModel(int n) {
        this.kind = n;
    }

    public List<TopComponent> getTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(this.openedTopComponents);
        ArrayList<String> arrayList2 = new ArrayList<String>(this.tcIDs);
        ArrayList<TopComponent> arrayList3 = new ArrayList<TopComponent>(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TopComponent topComponent = TopComponentSubModel.getTopComponent(string);
            if (topComponent != null) {
                arrayList3.add(topComponent);
                continue;
            }
            iterator.remove();
        }
        arrayList3.removeAll(this.openedTopComponents);
        arrayList.addAll(arrayList3);
        return arrayList;
    }

    public List<TopComponent> getOpenedTopComponents() {
        return new ArrayList<TopComponent>(this.openedTopComponents);
    }

    public boolean addOpenedTopComponent(TopComponent topComponent) {
        Object object;
        Object object2;
        if (this.openedTopComponents.contains(topComponent)) {
            return false;
        }
        String string = TopComponentSubModel.getID(topComponent);
        int n = this.tcIDs.indexOf(string);
        int n2 = this.openedTopComponents.size();
        if (n >= 0) {
            object2 = this.openedTopComponents.iterator();
            while (object2.hasNext()) {
                object = (TopComponent)object2.next();
                String string2 = TopComponentSubModel.getID(object);
                int n3 = this.tcIDs.indexOf(string2);
                if (n3 < n) continue;
                n2 = this.openedTopComponents.indexOf(object);
                break;
            }
        }
        if ((object2 = TopComponentSubModel.getTopComponent(string)) != topComponent) {
            object = "Model in inconsistent state, generated TC ID=" + string + " for " + topComponent.getClass() + ":" + topComponent.hashCode() + " but" + " that ID is reserved for TC=" + object2.getClass() + ":" + object2.hashCode();
            assert (false) : object;
        }
        this.openedTopComponents.add(n2, topComponent);
        if (!this.tcIDs.contains(string)) {
            this.tcIDs.add(string);
        }
        if (this.selectedTopComponentID == null && !this.isNullSelectionAllowed()) {
            this.selectedTopComponentID = string;
        }
        if (this.kind == 2) {
            this.setSlidingProperty(topComponent);
        } else {
            this.clearSlidingProperty(topComponent);
        }
        return true;
    }

    public boolean insertOpenedTopComponent(TopComponent topComponent, int n) {
        if (n >= 0 && !this.openedTopComponents.isEmpty() && this.openedTopComponents.size() > n && this.openedTopComponents.get(n) == topComponent) {
            return false;
        }
        this.openedTopComponents.remove(topComponent);
        int n2 = n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.openedTopComponents.size()) {
            n2 = this.openedTopComponents.size();
        }
        String string = TopComponentSubModel.getID(topComponent);
        this.tcIDs.remove(string);
        this.openedTopComponents.add(n2, topComponent);
        if (n2 == 0) {
            this.tcIDs.add(0, string);
        } else {
            TopComponent topComponent2 = this.openedTopComponents.get(n2 - 1);
            int n3 = this.tcIDs.indexOf(TopComponentSubModel.getID(topComponent2));
            this.tcIDs.add(n3 + 1, string);
        }
        if (this.selectedTopComponentID == null && !this.isNullSelectionAllowed()) {
            this.selectedTopComponentID = TopComponentSubModel.getID(topComponent);
        }
        if (this.kind == 2) {
            this.setSlidingProperty(topComponent);
        } else {
            this.clearSlidingProperty(topComponent);
        }
        return true;
    }

    public boolean addClosedTopComponent(TopComponent topComponent) {
        int n = this.openedTopComponents.indexOf(topComponent);
        String string = TopComponentSubModel.getID(topComponent);
        if (!this.tcIDs.contains(string)) {
            this.tcIDs.add(string);
        }
        if (n != -1) {
            this.openedTopComponents.remove(topComponent);
            if (this.selectedTopComponentID != null && this.selectedTopComponentID.equals(TopComponentSubModel.getID(topComponent))) {
                this.adjustSelectedTopComponent(n, null);
            }
        }
        if (this.kind == 2) {
            this.setSlidingProperty(topComponent);
        } else {
            this.clearSlidingProperty(topComponent);
        }
        return true;
    }

    public boolean addUnloadedTopComponent(String string) {
        if (!this.tcIDs.contains(string)) {
            this.tcIDs.add(string);
        }
        return true;
    }

    public boolean removeTopComponent(TopComponent topComponent, TopComponent topComponent2) {
        boolean bl;
        String string = TopComponentSubModel.getID(topComponent);
        if (this.openedTopComponents.contains(topComponent)) {
            if (this.selectedTopComponentID != null && this.selectedTopComponentID.equals(string)) {
                int n = this.openedTopComponents.indexOf(TopComponentSubModel.getTopComponent(this.selectedTopComponentID));
                this.openedTopComponents.remove(topComponent);
                this.adjustSelectedTopComponent(n, topComponent2);
            } else {
                this.openedTopComponents.remove(topComponent);
            }
            this.tcIDs.remove(string);
            bl = true;
        } else if (this.tcIDs.contains(string)) {
            this.tcIDs.remove(string);
            bl = true;
        } else {
            bl = false;
        }
        this.clearSlidingProperty(topComponent);
        return bl;
    }

    public boolean containsTopComponent(TopComponent topComponent) {
        return this.openedTopComponents.contains(topComponent) || this.tcIDs.contains(TopComponentSubModel.getID(topComponent));
    }

    public int getOpenedTopComponentTabPosition(TopComponent topComponent) {
        return this.openedTopComponents.indexOf(topComponent);
    }

    public boolean isEmpty() {
        return this.tcIDs.isEmpty();
    }

    private void adjustSelectedTopComponent(int n, TopComponent topComponent) {
        if (this.openedTopComponents.isEmpty() || this.isNullSelectionAllowed()) {
            this.selectedTopComponentID = null;
            return;
        }
        if (null != topComponent && this.openedTopComponents.contains(topComponent)) {
            this.selectedTopComponentID = TopComponentSubModel.getID(topComponent);
        } else {
            if (n > this.openedTopComponents.size() - 1) {
                n = this.openedTopComponents.size() - 1;
            }
            this.selectedTopComponentID = TopComponentSubModel.getID(this.openedTopComponents.get(n));
        }
    }

    private boolean isNullSelectionAllowed() {
        return this.kind == 2;
    }

    public void setSelectedTopComponent(TopComponent topComponent) {
        if (topComponent != null && !this.openedTopComponents.contains(topComponent)) {
            return;
        }
        this.selectedTopComponentID = topComponent == null && this.isNullSelectionAllowed() ? null : TopComponentSubModel.getID(topComponent);
    }

    public void setPreviousSelectedTopComponentID(String string) {
        this.previousSelectedTopComponentID = string;
    }

    public void setUnloadedSelectedTopComponent(String string) {
        if (string != null && !this.getOpenedTopComponentsIDs().contains(string)) {
            return;
        }
        this.selectedTopComponentID = string;
    }

    public void setUnloadedPreviousSelectedTopComponent(String string) {
        this.previousSelectedTopComponentID = string;
    }

    public List<String> getOpenedTopComponentsIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.openedTopComponents.size());
        Iterator<TopComponent> iterator = this.openedTopComponents.iterator();
        while (iterator.hasNext()) {
            arrayList.add(TopComponentSubModel.getID(iterator.next()));
        }
        return arrayList;
    }

    public List<String> getClosedTopComponentsIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.tcIDs);
        arrayList.removeAll(this.getOpenedTopComponentsIDs());
        return arrayList;
    }

    public List<String> getTopComponentsIDs() {
        return new ArrayList<String>(this.tcIDs);
    }

    public void removeClosedTopComponentID(String string) {
        this.tcIDs.remove(string);
    }

    public TopComponent getSelectedTopComponent() {
        return TopComponentSubModel.getTopComponent(this.selectedTopComponentID);
    }

    public String getPreviousSelectedTopComponentID() {
        return this.previousSelectedTopComponentID;
    }

    private static TopComponent getTopComponent(String string) {
        return WindowManagerImpl.getInstance().getTopComponentForID(string);
    }

    private static String getID(TopComponent topComponent) {
        return WindowManagerImpl.getInstance().findTopComponentID(topComponent);
    }

    private void setSlidingProperty(TopComponent topComponent) {
        topComponent.putClientProperty((Object)IS_SLIDING, (Object)Boolean.TRUE);
    }

    private void clearSlidingProperty(TopComponent topComponent) {
        topComponent.putClientProperty((Object)IS_SLIDING, null);
    }
}

