/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfileCollectorPanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;

public class LiveFlatProfilePanel
extends JPanel
implements LiveResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String NO_RESULTS_STRING = messages.getString("LiveFlatProfilePanel_NoResultsString");
    private CPUResUserActionsHandler actionsHandler = null;
    private Collection statModules = null;
    private CPUSelectionHandler handler = new CPUSelectionHandler(){

        @Override
        public void methodSelected(int n, int n2, int n3) {
            Iterator iterator = LiveFlatProfilePanel.this.statModules.iterator();
            while (iterator.hasNext()) {
                ((StatisticalModule)iterator.next()).setSelectedMethodId(n2);
            }
        }
    };
    private JPanel noResultsPanel = null;
    private JPanel resultsTable = null;
    private LiveFlatProfileCollectorPanel fpCollectorPanel = null;
    private TargetAppRunner runner;

    public LiveFlatProfilePanel(TargetAppRunner targetAppRunner, CPUResUserActionsHandler cPUResUserActionsHandler, Collection collection) {
        this.actionsHandler = cPUResUserActionsHandler;
        this.runner = targetAppRunner;
        this.statModules = collection;
        this.initComponents();
        this.setupFlatCollector();
    }

    @Override
    public int getSortingColumn() {
        return this.fpCollectorPanel.getSortingColumn();
    }

    @Override
    public boolean getSortingOrder() {
        return this.fpCollectorPanel.getSortingOrder();
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        return this.fpCollectorPanel.getViewImage(bl);
    }

    @Override
    public String getViewName() {
        return this.fpCollectorPanel.getViewName();
    }

    @Override
    public boolean fitsVisibleArea() {
        return this.fpCollectorPanel.fitsVisibleArea();
    }

    @Override
    public void handleRemove() {
        this.fpCollectorPanel.handleRemove();
    }

    @Override
    public void handleShutdown() {
        this.handleRemove();
        this.fpCollectorPanel.handleShutdown();
    }

    public boolean hasValidDrillDown() {
        return false;
    }

    @Override
    public boolean hasView() {
        return this.fpCollectorPanel.hasView();
    }

    @Override
    public void reset() {
        this.fpCollectorPanel.reset();
    }

    @Override
    public boolean supports(int n) {
        return this.fpCollectorPanel.supports(n);
    }

    @Override
    public void updateLiveResults() {
        this.fpCollectorPanel.updateLiveResults();
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.fpCollectorPanel.exportData(n, exportDataDumper, string);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.noResultsPanel = new JPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel(NO_RESULTS_STRING);
        jLabel.setFont(jLabel.getFont().deriveFont(14));
        jLabel.setEnabled(false);
        this.noResultsPanel.add((Component)jLabel, "North");
        this.resultsTable = new JPanel(new CardLayout());
        this.resultsTable.add((Component)jLabel, "NORESULTS");
        this.add((Component)this.resultsTable, "Center");
    }

    private void setupFlatCollector() {
        this.fpCollectorPanel = new LiveFlatProfileCollectorPanel(this.runner, this.actionsHandler, this.handler);
        this.resultsTable.add((Component)this.fpCollectorPanel, "RESULTS");
        ((CardLayout)this.resultsTable.getLayout()).show(this.resultsTable, "RESULTS");
    }
}

