/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.core.startup.NbProblemDisplayer;

public class ConsistencyVerifier {
    private ConsistencyVerifier() {
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set) throws IllegalArgumentException {
        return ConsistencyVerifier.findInconsistencies(set, null);
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set, Set<String> set2) throws IllegalArgumentException {
        return ConsistencyVerifier.findInconsistencies(set, set2, true);
    }

    static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set, Set<String> set2, boolean bl) throws IllegalArgumentException {
        String string;
        ModuleManager moduleManager = new ModuleManager((ModuleInstaller)new DummyInstaller(), (Events)new DummyEvents());
        moduleManager.mutexPrivileged().enterWriteAccess();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("OpenIDE-Module", "__dummy__");
        manifest.getMainAttributes().putValue("OpenIDE-Module-Provides", "org.openide.modules.ModuleFormat1, org.openide.modules.ModuleFormat2, org.openide.modules.os.Unix, org.openide.modules.os.PlainUnix, org.openide.modules.os.Windows, org.openide.modules.os.MacOSX, org.openide.modules.os.Linux, org.openide.modules.os.Solaris, org.openide.modules.os.OS2");
        manifest.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
        try {
            moduleManager.createFixed(manifest, null, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Manifest object2 : set) {
            try {
                object2.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
                object2.getMainAttributes().remove(new Attributes.Name("OpenIDE-Module-Friends"));
                object2.getMainAttributes().remove(new Attributes.Name("OpenIDE-Module-Localizing-Bundle"));
                boolean exception = "true".equals(object2.getMainAttributes().getValue("autoload"));
                boolean module = "true".equals(object2.getMainAttributes().getValue("eager"));
                string = moduleManager.createFixed(object2, null, ClassLoader.getSystemClassLoader(), exception, module);
                hashSet.add(string);
                if (exception || module) continue;
                hashSet2.add(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error parsing " + object2.getMainAttributes().entrySet() + ": " + exception, exception);
            }
        }
        TreeMap treeMap = new TreeMap();
        List list = moduleManager.simulateEnable(hashSet2);
        for (Module module : hashSet) {
            string = module.getCodeNameBase();
            Set set3 = module.getProblems();
            if (set3.isEmpty()) {
                if (set2 == null || set2.contains(string) || !module.isAutoload() || list.contains(module) || "true".equals(module.getAttribute("OpenIDE-Module-Deprecated"))) continue;
                treeMap.put(string, new TreeSet<String>(Collections.singleton("module is autoload but would not be enabled")));
                continue;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Object e : set3) {
                String string2 = bl ? NbProblemDisplayer.messageForProblem(module, e, false) : e.toString();
                treeSet.add(string2);
            }
            treeMap.put(string, treeSet);
        }
        return treeMap;
    }

    private static final class DummyEvents
    extends Events {
        private DummyEvents() {
        }

        protected void logged(String string, Object[] objectArray) {
        }
    }

    private static final class DummyInstaller
    extends ModuleInstaller {
        private DummyInstaller() {
        }

        public void prepare(Module module) throws InvalidException {
            throw new AssertionError();
        }

        public void dispose(Module module) {
            throw new AssertionError();
        }

        public void load(List<Module> list) {
            throw new AssertionError();
        }

        public void unload(List<Module> list) {
            throw new AssertionError();
        }

        public boolean closing(List<Module> list) {
            throw new AssertionError();
        }

        public void close(List<Module> list) {
            throw new AssertionError();
        }
    }
}

