/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.gtk;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.netbeans.swing.plaf.util.UIUtils;

final class ThemeValue
implements UIDefaults.ActiveValue {
    private final Object fallback;
    private final Object aRegion;
    private Object aColorType = null;
    private boolean darken = false;
    private Object value = null;
    private static Boolean functioning = null;
    private int ct = 0;
    private static boolean log = Boolean.getBoolean("themeValue.log");
    private static JButton dummyButton = null;
    private static Class<?> synthLookAndFeel = null;
    private static Class<?> gtkLookAndFeel = null;
    private static Class<?> colorType = null;
    private static Class<?> region = null;
    private static Class<?> synthStyle = null;
    private static Class<?> synthContext = null;
    private static Class<?> gtkColorType = null;
    private static Class<?> synthUI = null;
    private static Constructor synthContextConstructor;
    private static Method synthStyle_getColorForState;
    private static Method synthStyle_getFontForState;
    private static Method synthLookAndFeel_getStyle;
    private static Method synthContext_getContext;
    private static Method synthUI_getContext;
    static Object REGION_BUTTON;
    static Object REGION_PANEL;
    static Object REGION_SCROLLBAR_THUMB;
    static Object REGION_TAB;
    static Object REGION_INTFRAME;
    static Object LIGHT;
    static Object DARK;
    static Object BLACK;
    static Object WHITE;
    static Object MID;
    static Object TEXT_FOREGROUND;
    static Object TEXT_BACKGROUND;
    static Object FOCUS;
    private static HashSet<ThemeValue> instances;

    public ThemeValue(Object object, Object object2, Object object3) {
        this.fallback = object3;
        this.aRegion = object;
        this.aColorType = object2;
        ThemeValue.register(this);
    }

    public ThemeValue(Object object, Object object2, Object object3, boolean bl) {
        this.fallback = object3;
        this.aRegion = object;
        this.aColorType = object2;
        this.darken = bl;
        ThemeValue.register(this);
    }

    public ThemeValue(Object object, Font font) {
        this.fallback = font;
        this.aRegion = object;
        ThemeValue.register(this);
    }

    @Override
    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            if (!ThemeValue.functioning()) {
                this.value = this.fallback;
            } else if (this.fallback instanceof Font) {
                Font font = this.getFont();
                if (this.ct++ < 4) {
                    return font;
                }
                this.value = font;
            } else {
                this.value = this.getColor();
            }
        }
        return this.value != null ? this.value : this.fallback;
    }

    void clear() {
        this.value = null;
    }

    public Font getFont() {
        block4: {
            Object object = ThemeValue.getSynthStyle(this.aRegion);
            if (Boolean.TRUE.equals(functioning)) {
                try {
                    Font font = (Font)synthStyle_getFontForState.invoke(object, ThemeValue.getSynthContext());
                    if (font == null) {
                        font = (Font)this.fallback;
                    }
                    return font;
                }
                catch (Exception exception) {
                    functioning = Boolean.FALSE;
                    if (!log) break block4;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public Color getColor() {
        block5: {
            Object object = ThemeValue.getSynthStyle(this.aRegion);
            if (Boolean.TRUE.equals(functioning)) {
                try {
                    Color color = (Color)synthStyle_getColorForState.invoke(object, ThemeValue.getSynthContext(), this.aColorType);
                    if (color == null) {
                        color = (Color)this.fallback;
                    }
                    if (this.darken) {
                        color = color.darker();
                    }
                    return color;
                }
                catch (Exception exception) {
                    functioning = Boolean.FALSE;
                    if (!log) break block5;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean functioning() {
        if (functioning == null) {
            ThemeValue.checkFunctioning();
        }
        return functioning;
    }

    private static void checkFunctioning() {
        functioning = Boolean.FALSE;
        try {
            gtkLookAndFeel = UIUtils.classForName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            synthLookAndFeel = UIUtils.classForName("javax.swing.plaf.synth.SynthLookAndFeel");
            region = UIUtils.classForName("javax.swing.plaf.synth.Region");
            synthStyle = UIUtils.classForName("javax.swing.plaf.synth.SynthStyle");
            synthContext = UIUtils.classForName("javax.swing.plaf.synth.SynthContext");
            colorType = UIUtils.classForName("javax.swing.plaf.synth.ColorType");
            gtkColorType = UIUtils.classForName("com.sun.java.swing.plaf.gtk.GTKColorType");
            synthUI = UIUtils.classForName("sun.swing.plaf.synth.SynthUI");
            synthContextConstructor = synthContext.getDeclaredConstructor(JComponent.class, region, synthStyle, Integer.TYPE);
            synthContextConstructor.setAccessible(true);
            synthStyle_getColorForState = synthStyle.getDeclaredMethod("getColorForState", synthContext, colorType);
            synthStyle_getColorForState.setAccessible(true);
            synthStyle_getFontForState = synthStyle.getDeclaredMethod("getFontForState", synthContext);
            synthStyle_getFontForState.setAccessible(true);
            LIGHT = ThemeValue.valueOfField(gtkColorType, "LIGHT");
            DARK = ThemeValue.valueOfField(gtkColorType, "DARK");
            MID = ThemeValue.valueOfField(gtkColorType, "MID");
            BLACK = ThemeValue.valueOfField(gtkColorType, "BLACK");
            WHITE = ThemeValue.valueOfField(gtkColorType, "WHITE");
            TEXT_FOREGROUND = ThemeValue.valueOfField(colorType, "TEXT_FOREGROUND");
            TEXT_BACKGROUND = ThemeValue.valueOfField(colorType, "TEXT_BACKGROUND");
            FOCUS = ThemeValue.valueOfField(colorType, "FOCUS");
            synthContext_getContext = synthContext.getDeclaredMethod("getContext", Class.class, JComponent.class, region, synthStyle, Integer.TYPE);
            synthContext_getContext.setAccessible(true);
            synthLookAndFeel_getStyle = synthLookAndFeel.getDeclaredMethod("getStyle", JComponent.class, region);
            synthLookAndFeel_getStyle.setAccessible(true);
            REGION_BUTTON = ThemeValue.valueOfField(region, "BUTTON");
            REGION_PANEL = ThemeValue.valueOfField(region, "PANEL");
            REGION_SCROLLBAR_THUMB = ThemeValue.valueOfField(region, "SCROLL_BAR_THUMB");
            REGION_TAB = ThemeValue.valueOfField(region, "TABBED_PANE_TAB");
            REGION_INTFRAME = ThemeValue.valueOfField(region, "INTERNAL_FRAME_TITLE_PANE");
            synthUI_getContext = synthUI.getDeclaredMethod("getContext", JComponent.class);
            functioning = Boolean.TRUE;
        }
        catch (Exception exception) {
            System.err.println("Cannot initialize GTK colors - using hardcoded defaults: " + exception);
            if (log) {
                exception.printStackTrace();
            }
            return;
        }
    }

    private static JButton getDummyButton() {
        Object object;
        if (dummyButton == null) {
            dummyButton = new JButton();
            object = new CellRendererPane();
            ((Container)object).add(dummyButton);
        }
        object = dummyButton.getModel();
        return dummyButton;
    }

    private static Object getSynthContext() {
        try {
            JButton jButton = ThemeValue.getDummyButton();
            if (synthUI.isAssignableFrom(jButton.getUI().getClass())) {
                return synthUI_getContext.invoke((Object)jButton.getUI(), jButton);
            }
            throw new IllegalStateException("I don't have a SynthButtonUI to play with");
        }
        catch (Exception exception) {
            functioning = Boolean.FALSE;
            if (log) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private static Object getSynthStyle(Object object) {
        try {
            return synthLookAndFeel_getStyle.invoke(null, ThemeValue.getDummyButton(), object);
        }
        catch (Exception exception) {
            functioning = Boolean.FALSE;
            if (log) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private static Object valueOfField(Class clazz, String string) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        return field.get(null);
    }

    private static synchronized void register(ThemeValue themeValue) {
        if (instances == null) {
            instances = new HashSet();
            ThemeValue.registerPcl();
        }
        instances.add(themeValue);
    }

    private static void registerPcl() {
        Listener listener = new Listener();
        UIManager.addPropertyChangeListener(listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Gtk/FontName", listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Xft/DPI", listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Net/ThemeName", listener);
    }

    static {
        synthStyle_getColorForState = null;
        synthStyle_getFontForState = null;
        synthLookAndFeel_getStyle = null;
        synthContext_getContext = null;
        synthUI_getContext = null;
        REGION_BUTTON = null;
        REGION_PANEL = null;
        REGION_SCROLLBAR_THUMB = null;
        REGION_TAB = null;
        REGION_INTFRAME = null;
        LIGHT = null;
        DARK = null;
        BLACK = null;
        WHITE = null;
        MID = null;
        TEXT_FOREGROUND = null;
        TEXT_BACKGROUND = null;
        FOCUS = null;
        instances = null;
        ThemeValue.functioning();
    }

    private static class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof UIManager && "lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                String string = UIManager.getLookAndFeel().getClass().getName();
                if (string.indexOf("gtk") < 0) {
                    UIManager.removePropertyChangeListener(this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Gtk/FontName", this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Xft/DPI", this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Net/ThemeName", this);
                }
            } else {
                for (ThemeValue themeValue : instances) {
                    themeValue.clear();
                }
            }
        }
    }
}

