/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts;

import com.sun.tools.visualvm.charts.xy.SimpleXYChartUtils;
import com.sun.tools.visualvm.charts.xy.XYPaintersModel;
import com.sun.tools.visualvm.charts.xy.XYStorage;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;

public final class SimpleXYChartSupport {
    private static final Logger LOGGER = Logger.getLogger(SimpleXYChartSupport.class.getName());
    public static final long MIN_UNDEFINED = Long.MAX_VALUE;
    public static final long MAX_UNDEFINED = Long.MIN_VALUE;
    private final String chartTitle;
    private final String xAxisDescription;
    private final String yAxisDescription;
    private final int chartType;
    private final boolean hideItems;
    private final Color[] itemColors;
    private final long initialYMargin;
    private final String[] detailsItems;
    private final double chartFactor;
    private final XYStorage storage;
    private final SynchronousXYItemsModel itemsModel;
    private final XYPaintersModel paintersModel;
    private JComponent chartUI;
    private SimpleXYChartUtils.DetailsHandle detailsHandle;

    public JComponent getChart() {
        if (this.chartUI == null) {
            this.chartUI = SimpleXYChartUtils.createChartUI(this.chartTitle, this.xAxisDescription, this.yAxisDescription, this.chartType, this.itemColors, this.initialYMargin, this.hideItems, this.chartFactor, this.storage, this.itemsModel, this.paintersModel);
            if (this.detailsItems != null) {
                this.detailsHandle = SimpleXYChartUtils.createDetailsArea(this.detailsItems, this.chartUI);
            }
        }
        return this.chartUI;
    }

    public void saveValues(OutputStream os) throws IOException {
        this.storage.saveValues(os);
    }

    public void loadValues(InputStream is) throws IOException {
        this.storage.loadValues(is);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleXYChartSupport.this.itemsModel.valuesAdded();
            }
        });
    }

    public void addValues(final long timestamp, final long[] values) {
        Runnable valuesUpdater = new Runnable(){

            public void run() {
                SimpleXYChartSupport.this.storage.addValues(timestamp, values);
                try {
                    SimpleXYChartSupport.this.itemsModel.valuesAdded();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.INFO, "Results not synchronized", e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            valuesUpdater.run();
        } else {
            SwingUtilities.invokeLater(valuesUpdater);
        }
    }

    public void updateDetails(final String[] values) {
        Runnable detailsUpdater = new Runnable(){

            public void run() {
                SimpleXYChartSupport.this.detailsHandle.updateDetails(values);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            detailsUpdater.run();
        } else {
            SwingUtilities.invokeLater(detailsUpdater);
        }
    }

    public String formatDecimal(long value) {
        return SimpleXYChartUtils.formatDecimal((double)value * this.chartFactor);
    }

    public String formatBytes(long value) {
        return SimpleXYChartUtils.formatBytes((long)((double)value * this.chartFactor));
    }

    public String formatPercent(long value) {
        return SimpleXYChartUtils.formatPercent((double)value * this.chartFactor);
    }

    public String formatTime(long value) {
        int timestamps = this.storage.getTimestampsCount();
        if (timestamps == 0) {
            return SimpleXYChartUtils.formatTime(value, value, value);
        }
        return SimpleXYChartUtils.formatTime(value, this.storage.getTimestamp(0), this.storage.getTimestamp(timestamps - 1));
    }

    SimpleXYChartSupport(String chartTitle, String xAxisDescription, String yAxisDescription, int chartType, long initialYMargin, String[] itemNames, Color[] itemColors, float[] lineWidths, Color[] lineColors, Color[] fillColors1, Color[] fillColors2, long minValue, long maxValue, double chartFactor, boolean hideItems, int valuesBuffer, String[] detailsItems) {
        this.chartTitle = chartTitle;
        this.xAxisDescription = xAxisDescription;
        this.yAxisDescription = yAxisDescription;
        this.chartType = chartType;
        this.hideItems = hideItems;
        this.itemColors = itemColors;
        this.initialYMargin = initialYMargin;
        this.detailsItems = detailsItems;
        this.chartFactor = chartFactor;
        this.storage = SimpleXYChartUtils.createStorage(valuesBuffer);
        this.itemsModel = SimpleXYChartUtils.createItemsModel(this.storage, itemNames, minValue, maxValue);
        this.paintersModel = SimpleXYChartUtils.createPaintersModel(lineWidths, lineColors, fillColors1, fillColors2, (ItemsModel)this.itemsModel);
    }
}

