/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;

public class HyperlinkTextArea
extends HTMLTextArea {
    private String originalText;
    private boolean selected = false;

    public HyperlinkTextArea() {
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(Color.DARK_GRAY);
        this.setOpaque(false);
        this.setFocusable(true);
        this.setHighlighter(null);
        this.setShowPopup(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (HyperlinkTextArea.this.isSelected()) {
                    return;
                }
                HyperlinkTextArea.this.setCursor(Cursor.getPredefinedCursor(12));
                if (HyperlinkTextArea.this.isFocusOwner()) {
                    return;
                }
                HyperlinkTextArea.this.decorateHighlight();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (HyperlinkTextArea.this.isSelected()) {
                    return;
                }
                HyperlinkTextArea.this.setCursor(Cursor.getDefaultCursor());
                if (HyperlinkTextArea.this.isFocusOwner()) {
                    return;
                }
                HyperlinkTextArea.this.decorateNormal();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!HyperlinkTextArea.this.isSelected()) {
                    HyperlinkTextArea.this.decorateHighlight();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!HyperlinkTextArea.this.isSelected()) {
                    HyperlinkTextArea.this.decorateNormal();
                }
            }
        });
    }

    public HyperlinkTextArea(String string) {
        this();
        this.setText(string);
    }

    public void updateAppearance() {
        if (this.isSelected() || this.isFocusOwner()) {
            this.decorateHighlight();
        } else {
            this.decorateNormal();
        }
    }

    public void setForeground(Color color) {
        String string = this.originalText;
        super.setForeground(color);
        this.originalText = string;
        super.setText(this.originalText);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (bl) {
            this.decorateHighlight();
        } else {
            this.decorateNormal();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setText(String string) {
        this.originalText = string;
        super.setText(string);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
    }

    protected Color getHighlightColor() {
        return Color.BLACK;
    }

    protected String getHighlightText(String string) {
        return "<u>" + string + "</u>";
    }

    protected Color getNormalColor() {
        return Color.DARK_GRAY;
    }

    protected String getNormalText(String string) {
        return string;
    }

    private void decorateHighlight() {
        this.setForeground(this.getHighlightColor());
        super.setText(this.getHighlightText(this.originalText));
    }

    private void decorateNormal() {
        this.setForeground(this.getNormalColor());
        super.setText(this.getNormalText(this.originalText));
    }
}

