/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Image;
import java.beans.FeatureDescriptor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.RendererFactory;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.nodes.Node;

final class SheetCellRenderer
implements TableCellRenderer {
    private RendererFactory factory = null;
    private boolean tableUI;
    boolean includeMargin = false;
    private ReusablePropertyEnv reusableEnv;
    private ReusablePropertyModel reusableModel;
    boolean suppressButton = false;
    int rbMax = 0;
    private JLabel htmlLabel = HtmlRenderer.createLabel();

    SheetCellRenderer(boolean bl, ReusablePropertyEnv reusablePropertyEnv, ReusablePropertyModel reusablePropertyModel) {
        this.tableUI = bl;
        this.reusableEnv = reusablePropertyEnv;
        this.reusableModel = reusablePropertyModel;
    }

    void setIncludeMargin(boolean bl) {
        this.includeMargin = bl;
    }

    void setSuppressButton(boolean bl) {
        this.suppressButton = bl;
    }

    void setRadioButtonMax(int n) {
        this.rbMax = n;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent;
        FeatureDescriptor featureDescriptor = (FeatureDescriptor)object;
        bl |= bl2 && jTable.getSelectedRow() == n;
        if (featureDescriptor == null || featureDescriptor instanceof Node.PropertySet) {
            return new JLabel();
        }
        if (n2 == 0) {
            boolean bl3;
            String string = ((Node.Property)featureDescriptor).getHtmlDisplayName();
            boolean bl4 = bl3 = string != null;
            if (!bl3) {
                string = featureDescriptor.getDisplayName();
            }
            JLabel jLabel = this.htmlLabel;
            HtmlRenderer.Renderer renderer = (HtmlRenderer.Renderer)jLabel;
            renderer.setHtml(bl3);
            jLabel.setText(string);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            jLabel.setOpaque(bl);
            if (this.includeMargin) {
                jLabel.setBorder(BorderFactory.createMatteBorder(0, PropUtils.getMarginWidth() + 2, 0, 0, jLabel.getBackground()));
            } else {
                jLabel.setBorder(BorderFactory.createMatteBorder(0, PropUtils.getTextMargin(), 0, 0, jLabel.getBackground()));
            }
            Object object2 = featureDescriptor.getValue("nameIcon");
            if (object2 instanceof Icon) {
                jLabel.setIcon((Icon)object2);
            } else if (object2 instanceof Image) {
                jLabel.setIcon(new ImageIcon((Image)object2));
            }
            jComponent = jLabel;
        } else {
            jComponent = this.factory().getRenderer((Node.Property)featureDescriptor);
            if (bl) {
                ((Component)jComponent).setBackground(jTable.getSelectionBackground());
                ((Component)jComponent).setForeground(jTable.getSelectionForeground());
            } else {
                ((Component)jComponent).setBackground(jTable.getBackground());
                ((Component)jComponent).setForeground(jTable.getForeground());
            }
            jComponent.setOpaque(bl);
        }
        return jComponent;
    }

    RendererFactory factory() {
        if (this.factory == null) {
            this.factory = new RendererFactory(true, this.reusableEnv, this.reusableModel);
        }
        return this.factory;
    }
}

